/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.task;

import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MyDate;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.TaskExtended;
import mausoleum.room.Room;
import mausoleum.task.PeriodTaskHelper;
import mausoleum.task.standards.StandardTask;

public class TaskCounter
implements Serializable,
Comparable {
    private static final long serialVersionUID = 1831843L;
    public static final int TERMIN_UEBERFAELLIG = 0;
    public static final int TERMIN_HEUTE = 1;
    public static final int TERMIN_1_2_TAGE = 2;
    public static final int TERMIN_3_5_TAGE = 3;
    public static final int TERMIN_ZUKUNFT = 4;
    public static final int MAX_TERMINE = 5;
    public static final int MODE_TASK = 0;
    public static final int MODE_MOUSE = 1;
    public static final int MODE_CAGE = 2;
    public static final int MAX_MODES = 3;
    public static final String ALL_MARK = "#*?ALL";
    public static final String OTHERS_MARK = "#*?OTHERS";
    public static String COM_GET_TASK_COUNTER = "GET_TASK_COUNTER";
    public String ivRoomname = null;
    public long ivRoomServiceID = -1L;
    public TaskCounterDetail ivAlle = new TaskCounterDetail();
    public TaskCounterDetail ivOthers = new TaskCounterDetail();
    public HashMap ivDetailsByDescr = new HashMap();
    static /* synthetic */ Class class$0;

    public static HashMap getTaskCounters(HashMap roomIdHashmapsByGroupName, Vector serviceRooms) {
        HashMap<Long, TaskCounter> taskCounterByServiceRoomID = new HashMap<Long, TaskCounter>();
        if (serviceRooms != null && !serviceRooms.isEmpty()) {
            Iterator iter = serviceRooms.iterator();
            while (iter.hasNext()) {
                Room room = (Room)iter.next();
                taskCounterByServiceRoomID.put(room.getLongID(), new TaskCounter(room.getString("ROM_NAME", ""), room.getID()));
            }
            int heute = MyDate.getTage(System.currentTimeMillis());
            HashMap<Long, Vector<Mouse>> interestingMiceByRoomID = new HashMap<Long, Vector<Mouse>>(20);
            HashMap<Long, Vector<Mouse>> interestingMiceByCageID = new HashMap<Long, Vector<Mouse>>(20);
            HashSet taskTypesByMouse = new HashSet();
            HashSet taskTypesByCage = new HashSet();
            Vector actualGroupMice = new Vector(300);
            TreeSet nextExecDateSammler = new TreeSet();
            Iterator iter2 = roomIdHashmapsByGroupName.keySet().iterator();
            while (iter2.hasNext()) {
                String group = (String)iter2.next();
                try {
                    if (!interestingMiceByRoomID.isEmpty()) {
                        Iterator iterator = interestingMiceByRoomID.values().iterator();
                        while (iterator.hasNext()) {
                            Vector v = (Vector)iterator.next();
                            v.clear();
                        }
                    }
                    actualGroupMice.clear();
                    Vector v = ObjectStore.getActualObjects(1, group);
                    if (v != null) {
                        actualGroupMice.addAll(v);
                    }
                    Iterator interstingMiceIter = actualGroupMice.iterator();
                    while (interstingMiceIter.hasNext()) {
                        Mouse mouse = (Mouse)interstingMiceIter.next();
                        TaskExtended[] arr = (TaskExtended[])mouse.get("MOS_TASKSEXT");
                        if (arr == null || arr.length == 0) continue;
                        try {
                            Long serviceRoomID;
                            Room room = mouse.getRoom();
                            if (room == null || (serviceRoomID = (Long)room.get("IDO_SERVID")) == null) continue;
                            Vector<Mouse> roomMice = (Vector<Mouse>)interestingMiceByRoomID.get(serviceRoomID);
                            if (roomMice == null) {
                                roomMice = new Vector<Mouse>(100);
                                interestingMiceByRoomID.put(serviceRoomID, roomMice);
                            }
                            roomMice.add(mouse);
                        }
                        catch (Throwable e) {
                            String string = "Problem while checking Mouse " + mouse;
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("mausoleum.task.TaskCounter");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Log.error(string, e, clazz);
                        }
                    }
                    if (!interestingMiceByRoomID.isEmpty()) {
                        Iterator iterator = interestingMiceByRoomID.keySet().iterator();
                        while (iterator.hasNext()) {
                            Long serviceRoomID = (Long)iterator.next();
                            TaskCounter tc = (TaskCounter)taskCounterByServiceRoomID.get(serviceRoomID);
                            if (tc != null) {
                                Vector mice = (Vector)interestingMiceByRoomID.get(serviceRoomID);
                                if (mice != null) {
                                    Iterator<Object> iterator2;
                                    if (!mice.isEmpty()) {
                                        interestingMiceByCageID.clear();
                                        iterator2 = mice.iterator();
                                        while (iterator2.hasNext()) {
                                            Mouse mouse = (Mouse)iterator2.next();
                                            Long cageID = new Long(mouse.getActCageIDFromARR(-1L));
                                            Vector<Mouse> cageMice = (Vector<Mouse>)interestingMiceByCageID.get(cageID);
                                            if (cageMice == null) {
                                                cageMice = new Vector<Mouse>(5);
                                                interestingMiceByCageID.put(cageID, cageMice);
                                            }
                                            cageMice.add(mouse);
                                        }
                                        mice.clear();
                                    }
                                    if (!interestingMiceByCageID.isEmpty()) {
                                        iterator2 = interestingMiceByCageID.keySet().iterator();
                                        while (iterator2.hasNext()) {
                                            Long cageID = (Long)iterator2.next();
                                            Vector cageMice = (Vector)interestingMiceByCageID.get(cageID);
                                            if (cageMice != null && !cageMice.isEmpty()) {
                                                try {
                                                    tc.handleCageMice(cageMice, heute, group, taskTypesByMouse, taskTypesByCage, nextExecDateSammler);
                                                }
                                                catch (Throwable e) {
                                                    String string = "Problem handling interestingMiceByCageID " + cageMice;
                                                    Class<?> clazz = class$0;
                                                    if (clazz == null) {
                                                        try {
                                                            clazz = Class.forName("mausoleum.task.TaskCounter");
                                                        }
                                                        catch (ClassNotFoundException classNotFoundException) {
                                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                        }
                                                    }
                                                    Log.error(string, e, clazz);
                                                }
                                                continue;
                                            }
                                            String string = "interestingMiceByCageID evaporated: " + cageMice + " for cageID " + cageID + " in group " + group;
                                            Class<?> clazz = class$0;
                                            if (clazz == null) {
                                                try {
                                                    clazz = Class.forName("mausoleum.task.TaskCounter");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                            }
                                            Log.error(string, null, clazz);
                                        }
                                    }
                                    interestingMiceByCageID.clear();
                                    continue;
                                }
                                String string = "Mice lost for serviceRoomID: " + serviceRoomID + " in Group " + group;
                                Class<?> clazz = class$0;
                                if (clazz == null) {
                                    try {
                                        clazz = Class.forName("mausoleum.task.TaskCounter");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                Log.error(string, null, clazz);
                                continue;
                            }
                            String string = "No TaskCounter found for serviceRoomID: " + serviceRoomID;
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("mausoleum.task.TaskCounter");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Log.error(string, null, clazz);
                        }
                        continue;
                    }
                    String string = "No interesting mice found for Group " + group;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("mausoleum.task.TaskCounter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.debug(string, clazz);
                }
                catch (Throwable e) {
                    String string = "Problem getting TaskCounters for Group " + group;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("mausoleum.task.TaskCounter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error(string, e, clazz);
                }
            }
            taskTypesByMouse = null;
            taskTypesByCage = null;
            actualGroupMice.clear();
            actualGroupMice = null;
            interestingMiceByCageID = null;
            interestingMiceByRoomID.clear();
            interestingMiceByRoomID = null;
            nextExecDateSammler.clear();
            nextExecDateSammler = null;
        } else {
            String string = "Trying to create task counters but there are no rooms: " + serviceRooms;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.task.TaskCounter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.warn(string, clazz);
        }
        return taskCounterByServiceRoomID;
    }

    private TaskCounter() {
    }

    private TaskCounter(String name, long serviceID) {
        this.ivRoomname = name;
        this.ivRoomServiceID = serviceID;
    }

    public int getNumber(String descr, int termin, int mode) {
        TaskCounterDetail tcd = null;
        tcd = ALL_MARK.equals(descr) ? this.ivAlle : (OTHERS_MARK.equals(descr) ? this.ivOthers : (TaskCounterDetail)this.ivDetailsByDescr.get(descr));
        if (tcd != null) {
            return tcd.ivData[termin][mode];
        }
        return 0;
    }

    public void addTaskTypes(TreeSet target) {
        if (ProcessDefinition.isClient()) {
            Iterator iterator = this.ivDetailsByDescr.keySet().iterator();
            while (iterator.hasNext()) {
                target.add(iterator.next());
            }
        }
    }

    private void handleCageMice(Vector cageMice, int heute, String group, HashSet typeByMouse, HashSet typeByCage, TreeSet nextExecDateSammler) {
        Iterator iter = cageMice.iterator();
        while (iter.hasNext()) {
            Mouse mouse = (Mouse)iter.next();
            this.handleMouse((TaskExtended[])mouse.get("MOS_TASKSEXT"), heute, group, typeByMouse, typeByCage, nextExecDateSammler);
        }
        cageMice.clear();
        typeByCage.clear();
    }

    private void handleMouse(TaskExtended[] arr, int heute, String group, HashSet typeByMouse, HashSet typeByCage, TreeSet nextExecDateSammler) {
        int i = 0;
        while (i < arr.length) {
            if (arr[i].ivStatus == 1 || arr[i].ivStatus == 2) {
                int pt = arr[i].ivProcType;
                String taskMark = null;
                TaskCounterDetail tcd = this.ivOthers;
                if (pt != 0 && pt != -1) {
                    taskMark = StandardTask.getDescription(group, pt, null, true, null);
                }
                if (taskMark != null) {
                    tcd = (TaskCounterDetail)this.ivDetailsByDescr.get(taskMark);
                    if (tcd == null) {
                        tcd = new TaskCounterDetail();
                        this.ivDetailsByDescr.put(taskMark, tcd);
                    }
                } else {
                    taskMark = OTHERS_MARK;
                }
                TaskCounter.handle(tcd, arr[i], taskMark, heute, typeByMouse, typeByCage, nextExecDateSammler);
                TaskCounter.handle(this.ivAlle, arr[i], ALL_MARK, heute, typeByMouse, typeByCage, nextExecDateSammler);
            }
            ++i;
        }
        typeByMouse.clear();
    }

    private static void handle(TaskCounterDetail tcd, TaskExtended tex, String mark, int heute, HashSet typeByMouse, HashSet typeByCage, TreeSet nextExecDateSammler) {
        boolean doMouse = !typeByMouse.contains(mark);
        boolean doCage = !typeByCage.contains(mark);
        tcd.handleTask(tex, heute, doMouse, doCage, nextExecDateSammler);
        if (doMouse) {
            typeByMouse.add(mark);
        }
        if (doCage) {
            typeByCage.add(mark);
        }
    }

    public String toString() {
        return "TC: [" + this.ivRoomname + "] ";
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof TaskCounter) {
            TaskCounter tc = (TaskCounter)arg0;
            return this.ivRoomname.compareToIgnoreCase(tc.ivRoomname);
        }
        return 0;
    }

    public class TaskCounterDetail
    implements Serializable {
        private static final long serialVersionUID = 149846816816816L;
        public int[][] ivData = new int[5][3];

        private void handleTask(TaskExtended tex, int heute, boolean doMouse, boolean doCage, TreeSet nextExecDateSammler) {
            if (tex.isPeriodTask()) {
                nextExecDateSammler.clear();
                PeriodTaskHelper.addDates(tex, heute, nextExecDateSammler);
                if (!nextExecDateSammler.isEmpty()) {
                    Integer lastDate;
                    Integer nextDate = (Integer)nextExecDateSammler.first();
                    if (nextDate < heute) {
                        this.addToMerker(0, doCage, doMouse);
                    }
                    if (nextExecDateSammler.contains(new Integer(heute))) {
                        this.addToMerker(1, doCage, doMouse);
                    }
                    if (nextExecDateSammler.contains(new Integer(heute + 1)) || nextExecDateSammler.contains(new Integer(heute + 2))) {
                        this.addToMerker(2, doCage, doMouse);
                    }
                    if (nextExecDateSammler.contains(new Integer(heute + 3)) || nextExecDateSammler.contains(new Integer(heute + 4)) || nextExecDateSammler.contains(new Integer(heute + 52))) {
                        this.addToMerker(3, doCage, doMouse);
                    }
                    if ((lastDate = (Integer)nextExecDateSammler.last()) >= heute + 6) {
                        this.addToMerker(4, doCage, doMouse);
                    }
                }
            } else {
                int ddiff = tex.ivDatum - heute;
                int target = -1;
                switch (ddiff) {
                    case 0: {
                        target = 1;
                        break;
                    }
                    case 1: 
                    case 2: {
                        target = 2;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        target = 3;
                        break;
                    }
                    default: {
                        target = ddiff < 0 ? 0 : 4;
                    }
                }
                this.addToMerker(target, doCage, doMouse);
            }
        }

        private void addToMerker(int target, boolean doCage, boolean doMouse) {
            if (target != -1) {
                int[] nArray = this.ivData[target];
                nArray[0] = nArray[0] + 1;
                if (doCage) {
                    int[] nArray2 = this.ivData[target];
                    nArray2[2] = nArray2[2] + 1;
                }
                if (doMouse) {
                    int[] nArray3 = this.ivData[target];
                    nArray3[1] = nArray3[1] + 1;
                }
            }
        }
    }
}

