/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.task;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterJob;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JScrollPane;
import mausoleum.factsheets.FactSheetComponentScreen;
import mausoleum.factsheets.FactSheetPrintPreviewFrame;
import mausoleum.factsheets.FactSheetPrinter;
import mausoleum.factsheets.PrintElementFactSheet;
import mausoleum.helper.FontManager;
import mausoleum.helper.WindowUtils;
import mausoleum.helper.Zeile;
import mausoleum.inspector.Inspector;
import mausoleum.printing.util.CPPageFormat;
import mausoleum.printing.util.CPPageFormatDialog;
import mausoleum.requester.MoreTextRequester;
import mausoleum.requester.pope.PopeAlert;
import mausoleum.task.DisplayTask;
import mausoleum.task.TaskScheduleColumn;
import mausoleum.task.TaskTreeNode;
import mausoleum.ui.UIDef;

public class TaskSchedule
extends FactSheetComponentScreen
implements ActionListener {
    private static final long serialVersionUID = 12134234L;
    public static final int ROW_DATE = 0;
    public static final int ROW_MORNING = 1;
    public static final int ROW_NOON = 2;
    public static final int ROW_AFTERNOON = 3;
    public static final int ROW_EVENING = 4;
    public static final int ROW_ANYTIME = 5;
    public static final int ANZ_ROWS = 6;
    public int[] TIME_PREFS_BY_ROW_NUMBER;
    public static final int TEXT_MARGIN = UIDef.getScaled(8);
    private static final TaskScheduleColumn[] COLUMNS = new TaskScheduleColumn[]{new TaskScheduleColumn(-1), new TaskScheduleColumn(0), new TaskScheduleColumn(1), new TaskScheduleColumn(2), new TaskScheduleColumn(3), new TaskScheduleColumn(4), new TaskScheduleColumn(5), new TaskScheduleColumn(6), new TaskScheduleColumn(7), new TaskScheduleColumn(8), new TaskScheduleColumn(9), new TaskScheduleColumn(10), new TaskScheduleColumn(11), new TaskScheduleColumn(12), new TaskScheduleColumn(13)};
    public static final int[] COMBO_VALS = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    public static final String[] COMBO_STRINGS = new String[]{"1 " + Babel.get("DAY"), "2 " + Babel.get("DAYS"), "3 " + Babel.get("DAYS"), "4 " + Babel.get("DAYS"), "5 " + Babel.get("DAYS"), "6 " + Babel.get("DAYS"), "7 " + Babel.get("DAYS"), "8 " + Babel.get("DAYS"), "9 " + Babel.get("DAYS"), "10 " + Babel.get("DAYS"), "11 " + Babel.get("DAYS"), "12 " + Babel.get("DAYS"), "13 " + Babel.get("DAYS"), "14 " + Babel.get("DAYS")};
    private static final double MAX_FACTOR = 2.0;
    private static final int MAX_ANZ_SPALTEN = COLUMNS.length;
    private static final int MAX_TEXT_WIDTH = UIDef.getScaled(120);
    public static boolean cvWithColor = true;
    private static TaskSchedule cvInstance = null;
    private final Vector ivSammler;
    private final Vector[][] ivElementSammler;
    private final int[] ivWidths;
    private final int[] ivHeights;
    private int ivUsedColumns;
    private final Vector ivDragDisplayTasks;
    private int ivDragTargetCol;
    private int ivDragTargetRow;
    private final PrintElementFactSheet[] ivDragMarker;
    public PrintElementFactSheet ivSelectedPE;

    public static TaskSchedule getInstance() {
        if (cvInstance == null) {
            cvInstance = new TaskSchedule();
        }
        return cvInstance;
    }

    private TaskSchedule() {
        super(false);
        int[] nArray = new int[6];
        nArray[0] = Integer.MAX_VALUE;
        nArray[1] = -1;
        nArray[2] = -2;
        nArray[3] = -3;
        nArray[4] = -4;
        this.TIME_PREFS_BY_ROW_NUMBER = nArray;
        this.ivSammler = new Vector();
        this.ivElementSammler = new Vector[MAX_ANZ_SPALTEN + 1][6];
        this.ivWidths = new int[MAX_ANZ_SPALTEN + 1];
        this.ivHeights = new int[6];
        this.ivUsedColumns = 8;
        this.ivDragDisplayTasks = new Vector();
        this.ivDragTargetCol = -1;
        this.ivDragTargetRow = -1;
        this.ivDragMarker = new PrintElementFactSheet[1];
        this.ivSelectedPE = null;
        this.ivShowLinks = false;
        this.getSettings();
        int col = 0;
        while (col < MAX_ANZ_SPALTEN + 1) {
            int row = 0;
            while (row < 6) {
                this.ivElementSammler[col][row] = new Vector();
                if (col == 0) {
                    String s = null;
                    if (row == 1) {
                        s = Babel.get("TASK_TIME_MORNING");
                    } else if (col == 0 && row == 2) {
                        s = Babel.get("TASK_TIME_NOON");
                    } else if (col == 0 && row == 3) {
                        s = Babel.get("TASK_TIME_AFTERNOON");
                    } else if (col == 0 && row == 4) {
                        s = Babel.get("TASK_TIME_EVENING");
                    } else if (col == 0 && row == 5) {
                        s = Babel.get("TASK_TIME_ANYTIME");
                    }
                    if (s != null) {
                        PrintElementFactSheet pfs = PrintElementFactSheet.getTextElement(0, 0, s, FontManager.getFont("SSB11"));
                        pfs.ivMargin = TEXT_MARGIN;
                        pfs.ivOrientation = 2;
                        this.ivElementSammler[col][row].add(pfs);
                    }
                }
                ++row;
            }
            ++col;
        }
        this.setDates();
        this.getTasks();
        TaskTreeNode.addActionListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setWithColor(boolean withColor) {
        if (withColor != cvWithColor) {
            cvWithColor = withColor;
            this.setDates();
            this.getTasks();
            this.repaint();
            this.rememberSettings();
        }
    }

    public void setUsedDays(int usedColumns) {
        if (usedColumns != this.ivUsedColumns && usedColumns >= 2) {
            this.ivUsedColumns = usedColumns;
            this.getTasks();
            this.revalidate();
            this.repaint();
            this.rememberSettings();
        }
    }

    public int getPeriodComboIndex() {
        int i = 0;
        while (i < COMBO_VALS.length) {
            if (COMBO_VALS[i] == this.ivUsedColumns) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean useColor() {
        return cvWithColor;
    }

    public void setDates() {
        int col = 0;
        while (col < MAX_ANZ_SPALTEN + 1) {
            int row = 0;
            while (row < 6) {
                if (row == 0 && col != 0) {
                    this.ivElementSammler[col][row].clear();
                    this.ivElementSammler[col][row].add(COLUMNS[col - 1].getDate(cvWithColor));
                }
                ++row;
            }
            ++col;
        }
    }

    public void manageResize() {
        this.ivFactor = 1.0;
        JScrollPane jsp = WindowUtils.getJScrollPane(this);
        if (jsp != null) {
            Dimension d = jsp.getViewport().getExtentSize();
            int innerWidth = d.width - 20;
            int ww = 0;
            int i = 0;
            while (i < this.ivUsedColumns + 1) {
                ww += this.ivWidths[i] + 1;
                ++i;
            }
            this.ivFactor = (double)innerWidth / (double)(ww + 20);
            if (this.ivFactor > 2.0) {
                this.ivFactor = 2.0;
            }
            this.revalidate();
            this.repaint();
        }
    }

    public void setDragDisplayTasks(Vector v) {
        this.ivDragDisplayTasks.clear();
        if (v != null && !v.isEmpty()) {
            this.ivDragDisplayTasks.addAll(v);
        }
    }

    private void getTasks() {
        this.ivSammler.clear();
        TaskTreeNode.ROOT.collectTasks(this.ivSammler);
        int heute = new MyDate(new GregorianCalendar()).getTage();
        int i = 0;
        while (i < COLUMNS.length) {
            COLUMNS[i].adapt(this.ivSammler, this.ivElementSammler, i + 1, cvWithColor, heute);
            ++i;
        }
        this.manageElements();
    }

    public void manageElements() {
        int y;
        Vector<PrintElementFactSheet> vv = new Vector<PrintElementFactSheet>();
        int row = 0;
        while (row < 6) {
            this.ivHeights[row] = 12;
            ++row;
        }
        int col = 0;
        while (col < this.ivUsedColumns + 1) {
            this.ivWidths[col] = MAX_TEXT_WIDTH;
            int row2 = 0;
            while (row2 < 6) {
                int sumh = 0;
                Vector v = this.ivElementSammler[col][row2];
                Iterator iter = v.iterator();
                while (iter.hasNext()) {
                    PrintElementFactSheet pfs = (PrintElementFactSheet)iter.next();
                    if (pfs.ivText == null) continue;
                    if (col != 0) {
                        pfs.setMaxWidth(MAX_TEXT_WIDTH);
                    }
                    int w = pfs.getTextWidth();
                    int h = pfs.getTextHeight();
                    if (w > this.ivWidths[col]) {
                        this.ivWidths[col] = w;
                    }
                    sumh += h;
                }
                if (sumh > this.ivHeights[row2]) {
                    this.ivHeights[row2] = sumh;
                }
                ++row2;
            }
            ++col;
        }
        this.ivMaxY = 0;
        int i = 0;
        while (i < this.ivHeights.length) {
            this.ivMaxY += this.ivHeights[i];
            ++i;
        }
        int x = 0;
        int col2 = 0;
        while (col2 < this.ivUsedColumns + 1) {
            y = 0;
            if (cvWithColor && col2 != 0) {
                vv.add(PrintElementFactSheet.getFilledBoxElement(x, y, this.ivWidths[col2], this.ivMaxY, TaskSchedule.COLUMNS[col2 - 1].ivBackground));
            }
            int row3 = 0;
            while (row3 < 6) {
                PrintElementFactSheet pfs;
                int innerY = y;
                Vector v = this.ivElementSammler[col2][row3];
                Vector<PrintElementFactSheet> horLines = new Vector<PrintElementFactSheet>();
                Iterator iter = v.iterator();
                while (iter.hasNext()) {
                    pfs = (PrintElementFactSheet)iter.next();
                    pfs.ivX = x;
                    pfs.ivY = innerY;
                    pfs.ivWidth = this.ivWidths[col2];
                    pfs.ivHeight = pfs.getTextHeight();
                    innerY += pfs.ivHeight;
                    vv.add(pfs);
                    if (col2 == 0) continue;
                    horLines.add(PrintElementFactSheet.getLineElement(x, innerY, x + this.ivWidths[col2], innerY));
                }
                vv.addAll(horLines);
                horLines.clear();
                innerY = y;
                v = this.ivElementSammler[col2][row3];
                iter = v.iterator();
                while (iter.hasNext()) {
                    pfs = (PrintElementFactSheet)iter.next();
                    innerY += pfs.ivHeight;
                    if (col2 == 0) continue;
                    if (cvWithColor && col2 == 1) {
                        horLines.add(PrintElementFactSheet.getLineElement(x, innerY, x + this.ivWidths[col2], innerY, Color.white));
                        continue;
                    }
                    horLines.add(PrintElementFactSheet.getLineElement(x, innerY, x + this.ivWidths[col2], innerY));
                }
                vv.addAll(horLines);
                y += this.ivHeights[row3];
                ++row3;
            }
            x += this.ivWidths[col2];
            ++col2;
        }
        x = 0;
        vv.add(PrintElementFactSheet.getLineElement(x, this.ivHeights[0], x, this.ivMaxY));
        col2 = 0;
        while (col2 < this.ivUsedColumns + 1) {
            int hx = x + this.ivWidths[col2];
            vv.add(PrintElementFactSheet.getLineElement(hx, 0, hx, this.ivMaxY));
            x += this.ivWidths[col2];
            ++col2;
        }
        int hinten = x;
        y = 0;
        vv.add(PrintElementFactSheet.getLineElement(this.ivWidths[0], y, hinten, y));
        int row4 = 0;
        while (row4 < 6) {
            int uy = y + this.ivHeights[row4];
            vv.add(PrintElementFactSheet.getLineElement(0, uy, hinten, uy));
            y += this.ivHeights[row4];
            ++row4;
        }
        this.ivElements.clear();
        this.ivElements.add(PrintElementFactSheet.getVectorElement(vv));
        this.ivFactor = Double.NaN;
        this.repaint();
    }

    public void actionPerformed(ActionEvent e) {
        this.getTasks();
    }

    public void printIt(boolean preview) {
        if (this.ivElements != null && !this.ivElements.isEmpty()) {
            CPPageFormat pageFormat;
            PrinterJob job = PrinterJob.getPrinterJob();
            String butTitel = Babel.get("PRINT");
            if (preview) {
                butTitel = Babel.get("PRINT_PREVIEW");
            }
            if ((pageFormat = CPPageFormatDialog.getPageFormat(WindowUtils.getJFrame(this), null, butTitel, null)) != null) {
                FactSheetPrinter fsp = new FactSheetPrinter(pageFormat, FactSheetPrinter.createDocument(this.ivElements, pageFormat, Babel.get("TASK_SCHEDULE"), false, false), job);
                if (this.ivElements != null && this.ivElements.size() == 1) {
                    fsp.setInnerFactor(FactSheetPrinter.getFactorForSingleElement((PrintElementFactSheet)this.ivElements.elementAt(0), pageFormat, false));
                }
                if (preview) {
                    new FactSheetPrintPreviewFrame(fsp);
                } else {
                    fsp.printIt();
                }
            }
        }
    }

    private void getSettings() {
        String s = WindowUtils.getSettings(this);
        if (s != null) {
            Zeile z = new Zeile(s, '|');
            this.ivUsedColumns = z.getInt(0, this.ivUsedColumns);
            cvWithColor = z.getString(1, "").equalsIgnoreCase("true");
        }
    }

    private void rememberSettings() {
        String s = String.valueOf(this.ivUsedColumns) + "|" + cvWithColor;
        WindowUtils.rememberSettings(this, s);
    }

    public Vector getHitDisplayTasks(MouseEvent e, PrintElementFactSheet[] found) {
        Object o = this.getElementAt(e.getPoint(), 7);
        if (o instanceof PrintElementFactSheet) {
            PrintElementFactSheet pfs = (PrintElementFactSheet)o;
            if (pfs.ivLink != null) {
                if (found != null) {
                    found[0] = pfs;
                }
                Zeile z = new Zeile(pfs.ivLink, '|');
                Vector sammler = new Vector();
                TaskTreeNode.ROOT.collectTasks(sammler);
                Vector<DisplayTask> v = new Vector<DisplayTask>();
                Iterator iter = sammler.iterator();
                while (iter.hasNext()) {
                    DisplayTask dt = (DisplayTask)iter.next();
                    if (dt.ivTask == null) continue;
                    long dtpi = dt.ivTask.ivPseudoID;
                    int i = 0;
                    while (i < z.size()) {
                        if (dtpi == z.getLong(i, 0L)) {
                            v.add(dt);
                        }
                        ++i;
                    }
                }
                return v;
            }
        }
        return null;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.ivDragMarker[0] = null;
        Vector v = this.getHitDisplayTasks(e, this.ivDragMarker);
        PrintElementFactSheet pe = this.ivDragMarker[0];
        this.ivDragMarker[0] = null;
        if (pe != null) {
            this.ivSonderElements.clear();
            this.ivSelectedPE = PrintElementFactSheet.getFilledBoxElement(pe.ivX, pe.ivY, pe.ivWidth, pe.ivHeight, new Color(230, 230, 230, 120), null);
            this.ivSelectedPE.ivBorderColor = Color.red;
            this.ivSelectedPE.ivLineWidth = 5.0f;
            this.ivSonderElements.add(this.ivSelectedPE);
            this.repaint();
        }
        if (v != null) {
            DisplayTask.getPermittedDateChangeDisplayTasks(v, this.ivDragDisplayTasks);
            if (!this.ivDragDisplayTasks.isEmpty() && pe != null) {
                this.ivDragMarker[0] = PrintElementFactSheet.getFilledBoxElement(pe.ivX, pe.ivY, pe.ivWidth, pe.ivHeight, new Color(230, 230, 230, 120), null);
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.ivDragDisplayTasks.isEmpty()) {
            if (this.ivDragTargetCol >= 2 && this.ivDragTargetRow >= 1) {
                String commentToAdd;
                Vector changings;
                int tage;
                int timepref = Integer.MAX_VALUE;
                if (this.ivDragTargetRow < this.TIME_PREFS_BY_ROW_NUMBER.length) {
                    timepref = this.TIME_PREFS_BY_ROW_NUMBER[this.ivDragTargetRow];
                }
                if (PopeAlert.checkTaskDateForHoliday(tage = MyDate.HEUTE + this.ivDragTargetCol - 2) && (changings = DisplayTask.getChangingTaskVec(this.ivDragDisplayTasks, tage, timepref)) != null && !changings.isEmpty() && (commentToAdd = MoreTextRequester.getText(Inspector.getInspector(), Babel.get("EXPLAIN_REASON"))) != null) {
                    Date newDate = new Date((long)tage * 86400000L);
                    HashMap obsByGroup = IDObject.sortByGroup(changings);
                    if (obsByGroup != null) {
                        Iterator iter = obsByGroup.keySet().iterator();
                        while (iter.hasNext()) {
                            String group = (String)iter.next();
                            Vector obs = (Vector)obsByGroup.get(group);
                            StringBuffer msb = new StringBuffer();
                            int i = 0;
                            while (i < obs.size()) {
                                if (msb.length() != 0) {
                                    msb.append("\n");
                                }
                                DisplayTask tcc = (DisplayTask)obs.elementAt(i);
                                msb.append(CommandManagerExecutive.getServiceRoomTag(group, tcc.ivComeFromType, tcc.ivComeFromID, ""));
                                msb.append("MALTERTASK").append(" ");
                                msb.append(tcc.ivComeFromID).append(" ");
                                msb.append(tcc.ivComeFromType).append(" ");
                                msb.append(Base64Manager.encodeBase64(tcc.ivTask.getInitString(-1, commentToAdd, newDate, timepref, Integer.MIN_VALUE, Integer.MIN_VALUE, -1, Integer.MIN_VALUE, Integer.MIN_VALUE)));
                                ++i;
                            }
                            RequestManager.sendCommandRequestAndGetAnswer(msb.toString(), group);
                            this.ivSelectedPE = null;
                        }
                    }
                }
            }
            this.ivSonderElements.clear();
            if (this.ivSelectedPE != null) {
                this.ivSonderElements.add(this.ivSelectedPE);
            }
            this.ivDragTargetCol = -1;
            this.ivDragTargetRow = -1;
            this.ivDragDisplayTasks.clear();
            this.ivDragMarker[0] = null;
            this.setCursor(Cursor.getDefaultCursor());
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.ivDragDisplayTasks.isEmpty()) {
            Cursor cursor = DisplayTask.createCursor(this.ivDragDisplayTasks, cvWithColor);
            if (cursor == null) {
                cursor = Cursor.getPredefinedCursor(12);
            }
            this.setCursor(cursor);
            Point np = this.getScaledPoint(e.getPoint());
            if (this.findRaster(np)) {
                this.repaint();
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
        String tooltip = null;
        Point np = this.getScaledPoint(e.getPoint());
        if (np.y <= this.ivHeights[0]) {
            tooltip = this.getHolidayTooltip(np);
        }
        this.setToolTipText(tooltip);
    }

    private String getHolidayTooltip(Point np) {
        int x = 0;
        int col = 0;
        while (col < this.ivWidths.length) {
            if (col >= 2 && np.x >= x && np.x <= x + this.ivWidths[col]) {
                if (TaskSchedule.COLUMNS[col - 1].ivIsWeekend) {
                    return Babel.get("WEEKEND");
                }
                return TaskSchedule.COLUMNS[col - 1].ivFeiertag;
            }
            x += this.ivWidths[col];
            ++col;
        }
        return null;
    }

    private boolean findRaster(Point p) {
        int altCol = this.ivDragTargetCol;
        int altRow = this.ivDragTargetRow;
        this.ivSonderElements.clear();
        if (this.ivDragMarker[0] != null) {
            this.ivSonderElements.add(this.ivDragMarker[0]);
        }
        this.ivDragTargetCol = -1;
        this.ivDragTargetRow = -1;
        int x = 0;
        int y = 0;
        int col = 0;
        while (col < this.ivWidths.length) {
            if (col >= 2 && p.x >= x && p.x <= x + this.ivWidths[col]) {
                int row = 0;
                while (row < this.ivHeights.length) {
                    if (row >= 1 && p.y > y && p.y <= y + this.ivHeights[row]) {
                        this.ivSonderElements.add(PrintElementFactSheet.getBoxElement(x, y, this.ivWidths[col], this.ivHeights[row], 5.0f, Color.red));
                        this.ivDragTargetCol = col;
                        this.ivDragTargetRow = row;
                        return altCol != this.ivDragTargetCol || altRow != this.ivDragTargetRow;
                    }
                    y += this.ivHeights[row];
                    ++row;
                }
                return altCol != this.ivDragTargetCol || altRow != this.ivDragTargetRow;
            }
            x += this.ivWidths[col];
            ++col;
        }
        return altCol != this.ivDragTargetCol || altRow != this.ivDragTargetRow;
    }
}

