/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.task;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import mausoleum.cage.Cage;
import mausoleum.helper.AllgUtils;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.LongPunkt;
import mausoleum.helper.Zeile;
import mausoleum.inspector.Inspector;
import mausoleum.main.DefaultManager;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.TaskExtended;
import mausoleum.rack.Rack;
import mausoleum.room.Room;
import mausoleum.tables.TableFrameTasks;
import mausoleum.task.DisplayTask;
import mausoleum.task.PeriodTaskHelper;
import mausoleum.task.TaskTreeMerker;

public class TaskTreeNode
implements TreeNode {
    private static final Comparator NODE_COMPARER = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            if (arg0 instanceof TaskTreeNode && arg1 instanceof TaskTreeNode) {
                TaskTreeNode tt0 = (TaskTreeNode)arg0;
                TaskTreeNode tt1 = (TaskTreeNode)arg1;
                if (tt0.ivComparable != null && tt1.ivComparable != null) {
                    return tt0.ivComparable.compareTo(tt1.ivComparable);
                }
                if (tt0.ivComparable == null && tt1.ivComparable != null) {
                    return 1;
                }
                if (tt0.ivComparable != null && tt1.ivComparable == null) {
                    return -1;
                }
            }
            return 0;
        }
    };
    public static final TaskTreeNode ROOT = new TaskTreeNode(Babel.get("TASK_ALL_TASKS"), null, null, true);
    public static final TaskTreeNode PENDING = new TaskTreeNode(Babel.get("TASK_PENDING"), ROOT, null, true);
    private static final TaskTreeNode IN_PROGRESS = new TaskTreeNode(Babel.get("TASK_IN_PROGRESS"), ROOT, null, true);
    private static final TaskTreeNode DONE = DefaultManager.showDoneTasks() ? new TaskTreeNode(Babel.get("TASK_DONE"), ROOT, null, true) : null;
    private static final TaskTreeNode REJECTED = DefaultManager.showRejectedTasks() ? new TaskTreeNode(Babel.get("TASK_REJECTED"), ROOT, null, true) : null;
    private static final TaskTreeNode WITHDRAWN = DefaultManager.showWithdrawnTasks() ? new TaskTreeNode(Babel.get("TASK_WITHDRAWN"), ROOT, null, true) : null;
    private static final TaskTreeNode UNFINSHED_REMOVED = new TaskTreeNode(Babel.get("TASK_UNFINISHED_REMOVED"), ROOT, null, true);
    private static final TaskTreeNode UNKNOWN = MausoleumClient.isServiceCaretaker() ? null : new TaskTreeNode(Babel.get("TASK_UNKNOWN"), ROOT, null, true);
    private static final TaskTreeNode TEMPORARY = new TaskTreeNode(Babel.get("TASK_TEMPORARY"), ROOT, null, true);
    public static final TreeNode[] PATH_ARR_TEMPORARY = new TreeNode[]{ROOT, TEMPORARY};
    public static final JTree TREE = new JTree(new DefaultTreeModel(ROOT));
    private static final Vector ACTIONLISTENERS = new Vector();
    public static final String TASK_CHANGED = "TASK_CHANGE";
    private final String ivTitel;
    private TaskTreeNode ivSuperNode = null;
    private Vector ivKids = null;
    private Vector ivTasks = null;
    private Comparable ivComparable = null;
    private Object ivFindObject = null;
    private final boolean ivCalcSumUp;
    public int ivMinDay = Integer.MAX_VALUE;
    public int ivLastCalcedSum = 0;

    public static void addActionListener(ActionListener al) {
        ACTIONLISTENERS.add(al);
    }

    public static void insert(Vector displayTasks, Vector idObjects) {
        HashSet touchedNodes = new HashSet();
        int i = 0;
        while (i < displayTasks.size()) {
            Vector v = TaskTreeNode.insertTask((DisplayTask)displayTasks.elementAt(i), null, (IDObject)idObjects.elementAt(i));
            if (!v.isEmpty()) {
                touchedNodes.addAll(v);
                Iterator iterator = v.iterator();
                while (iterator.hasNext()) {
                    TaskTreeNode ttn = (TaskTreeNode)iterator.next();
                    ttn.calcMinTaskDays();
                }
            }
            ++i;
        }
        TREE.setModel(new DefaultTreeModel(ROOT));
        TaskTreeNode.informListeners();
    }

    public static void addTemporaryTasks(Vector mice, boolean alsoHistorical) {
        if (TaskTreeNode.TEMPORARY.ivTasks == null) {
            TaskTreeNode.TEMPORARY.ivTasks = new Vector();
        }
        TaskTreeNode.TEMPORARY.ivTasks.clear();
        Iterator iter = mice.iterator();
        while (iter.hasNext()) {
            TaskTreeNode.addMouseTasks(TaskTreeNode.TEMPORARY.ivTasks, (Mouse)iter.next(), alsoHistorical);
        }
        TEMPORARY.calcMinTaskDays();
        DefaultTreeModel dtm = (DefaultTreeModel)TREE.getModel();
        dtm.nodeChanged(TEMPORARY);
    }

    public static void addMouseTasks(Vector target, Mouse mouse, boolean alsoHistorical) {
        TaskExtended[] tarr = (TaskExtended[])mouse.get("MOS_TASKSEXT");
        if (tarr != null) {
            int i = 0;
            while (i < tarr.length) {
                target.add(new DisplayTask(tarr[i], mouse));
                ++i;
            }
        }
        if (alsoHistorical) {
            long mouseID = mouse.getID();
            Vector users = ObjectStore.getActualObjects(6, mouse.getGroup());
            Iterator iterator = users.iterator();
            while (iterator.hasNext()) {
                User user = (User)iterator.next();
                tarr = (TaskExtended[])user.get("USR_TASKS");
                if (tarr == null) continue;
                int i = 0;
                while (i < tarr.length) {
                    if ((tarr[i].ivObjectType == 1 || tarr[i].ivObjectType == 0) && tarr[i].ivObjectID == mouseID) {
                        TaskTreeNode.addIfUnique(tarr[i], target, mouse);
                    }
                    ++i;
                }
            }
            int[] arr = new int[]{4, (int)mouseID};
            String s = (String)RequestManager.createSendAndGetObjectIfFinished((byte)84, arr, mouse.getGroup());
            if (s != null && s.length() != 0) {
                Vector tev = new Vector();
                TaskExtended.interpretDeletedTasks(s, tev);
                Iterator iterator2 = tev.iterator();
                while (iterator2.hasNext()) {
                    TaskTreeNode.addIfUnique((TaskExtended)iterator2.next(), target, mouse);
                }
            }
        }
    }

    private static void addIfUnique(TaskExtended tex, Vector displayTasks, Mouse mouse) {
        Iterator iterator = displayTasks.iterator();
        while (iterator.hasNext()) {
            DisplayTask dt = (DisplayTask)iterator.next();
            if (tex.ivPseudoID != dt.ivTask.ivPseudoID) continue;
            return;
        }
        displayTasks.add(new DisplayTask(tex, mouse));
    }

    public static void collectActiveTasksWithPseudoID(Vector target, LongPunkt pseudoID, String group, int typ) {
        PENDING.collectTasksWithPseudoID(target, pseudoID, group, typ, new HashSet());
    }

    public static synchronized void objectLeftServiceRoom(int objectTyp, String group, HashSet objectIDs) {
        HashMap displayTasksByID_CF = new HashMap();
        Iterator iter = objectIDs.iterator();
        while (iter.hasNext()) {
            Long idL = (Long)iter.next();
            ROOT.collectTasks(null, displayTasksByID_CF, group, idL, objectTyp);
        }
        boolean somethingChanged = false;
        Vector touchedNodes = new Vector();
        if (!displayTasksByID_CF.isEmpty()) {
            Iterator iter2 = displayTasksByID_CF.values().iterator();
            while (iter2.hasNext()) {
                DisplayTask soFar = (DisplayTask)iter2.next();
                Vector v = ROOT.removeTask(soFar, null);
                if (v.isEmpty()) continue;
                somethingChanged = true;
                touchedNodes.addAll(v);
            }
        }
        if (somethingChanged) {
            TaskTreeNode.adjustTreeForChanges(null, touchedNodes, false);
        }
    }

    public static synchronized void handleNewObject(IDObject obj) {
        if (obj != null) {
            DisplayTask soFar;
            String taskKey;
            if (obj instanceof User) {
                User loggedinUser = UserManager.getUser();
                if (loggedinUser == null) {
                    return;
                }
                if (obj.getID(-1L) != loggedinUser.getID(-2L)) {
                    return;
                }
            }
            String group = obj.getGroup("");
            long objectID = obj.getID();
            int objType = obj.getTyp();
            boolean esKamEinNeuerFremder = false;
            HashMap displayTasksByID = new HashMap();
            HashMap displayTasksByID_CF = new HashMap();
            ROOT.collectTasks(displayTasksByID, displayTasksByID_CF, group, objectID, objType);
            TaskExtended[] tarr = null;
            boolean useit = obj.isAliveAndVisible();
            if (obj instanceof Mouse) {
                Mouse mouse = (Mouse)obj;
                useit = useit && mouse.isTouchable();
            } else if (obj instanceof Cage) {
                Cage cage = (Cage)obj;
                boolean bl = useit = useit && cage.isTouchable();
            }
            if (useit && (taskKey = obj.getTaskKey()) != null) {
                tarr = (TaskExtended[])obj.get(taskKey);
            }
            Vector<TaskExtended> tasksToInsert = new Vector<TaskExtended>();
            Vector<DisplayTask> tasksToRemove = new Vector<DisplayTask>();
            if (tarr != null) {
                int i = 0;
                while (i < tarr.length) {
                    TaskExtended taskExt = tarr[i];
                    taskExt.clientSafety(obj);
                    Long key = new Long(taskExt.ivPseudoID);
                    displayTasksByID_CF.remove(key);
                    soFar = (DisplayTask)displayTasksByID.get(key);
                    if (soFar == null) {
                        tasksToInsert.add(taskExt);
                        if (!(taskExt.ivStatus != 1 || !MausoleumClient.isRegularOrTGService() && !MausoleumClient.isServiceCaretaker() || taskExt.ivIssuerGroup == null || taskExt.ivIssuerID == UserManager.getIDOFUser() && taskExt.ivIssuerGroup.equals(UserManager.getFirstGroup()))) {
                            esKamEinNeuerFremder = true;
                        }
                    } else if (taskExt.ivObjectID == soFar.ivTask.ivObjectID && taskExt.ivObjectType == soFar.ivTask.ivObjectType && !taskExt.equals(soFar.ivTask)) {
                        tasksToRemove.add(soFar);
                        tasksToInsert.add(taskExt);
                    }
                    ++i;
                }
            }
            boolean somethingChanged = false;
            Vector touchedNodes = new Vector();
            Iterator<Object> iter = displayTasksByID_CF.values().iterator();
            while (iter.hasNext()) {
                tasksToRemove.add((DisplayTask)iter.next());
            }
            iter = tasksToRemove.iterator();
            while (iter.hasNext()) {
                soFar = (DisplayTask)iter.next();
                Vector v = ROOT.removeTask(soFar, null);
                if (v.isEmpty()) continue;
                somethingChanged = true;
                touchedNodes.addAll(v);
            }
            Vector<DisplayTask> addedDisplayTasks = new Vector<DisplayTask>();
            Iterator iter2 = tasksToInsert.iterator();
            while (iter2.hasNext()) {
                TaskExtended task = (TaskExtended)iter2.next();
                DisplayTask mt = new DisplayTask(task, obj);
                Vector v = TaskTreeNode.insertTask(mt, null, obj);
                if (v.isEmpty()) continue;
                touchedNodes.addAll(v);
                Iterator iterator = v.iterator();
                while (iterator.hasNext()) {
                    TaskTreeNode ttn = (TaskTreeNode)iterator.next();
                    ttn.calcMinTaskDays();
                }
                addedDisplayTasks.add(mt);
                somethingChanged = true;
            }
            if (somethingChanged) {
                TaskTreeNode.adjustTreeForChanges(addedDisplayTasks, touchedNodes, esKamEinNeuerFremder);
            }
        }
    }

    private static void adjustTreeForChanges(Vector addedDisplayTasks, Vector touchedNodes, boolean esKamEinNeuerFremder) {
        DefaultTreeModel dtm = (DefaultTreeModel)TREE.getModel();
        TaskTreeNode.adjustTemporaryTasks(addedDisplayTasks, touchedNodes);
        TableFrameTasks.merkeSelektion();
        TaskTreeMerker merker = new TaskTreeMerker(TREE, TREE.getSelectionPath());
        dtm.nodeStructureChanged(ROOT);
        merker.manageTree(TREE, ROOT);
        Iterator iter = touchedNodes.iterator();
        while (iter.hasNext()) {
            TaskTreeNode node = (TaskTreeNode)iter.next();
            while (node != null) {
                dtm.nodeChanged(node);
                node = node.ivSuperNode;
            }
        }
        TaskTreeNode.informListeners();
        if (esKamEinNeuerFremder) {
            if (DefaultManager.cvOpticalTaskAlert) {
                Inspector.addAlarm(Babel.get("TASKS"), Babel.get("NEW_TASK_SUBMITTED"), 2);
            }
            if (DefaultManager.cvAcousticalTaskAlert) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
        TableFrameTasks.vergesseSelektion();
    }

    private static void adjustTemporaryTasks(Vector newDisplayTasks, Vector touchedNodes) {
        boolean somethingChanged = false;
        if (TEMPORARY != null && TaskTreeNode.TEMPORARY.ivTasks != null && newDisplayTasks != null) {
            Iterator iter = newDisplayTasks.iterator();
            while (iter.hasNext()) {
                DisplayTask dt = (DisplayTask)iter.next();
                int i = 0;
                while (i < TaskTreeNode.TEMPORARY.ivTasks.size()) {
                    DisplayTask odt = (DisplayTask)TaskTreeNode.TEMPORARY.ivTasks.elementAt(i);
                    if (TaskTreeNode.doTheyMatch(dt, odt)) {
                        TaskTreeNode.TEMPORARY.ivTasks.setElementAt(dt, i);
                        somethingChanged = true;
                    }
                    ++i;
                }
            }
        }
        if (somethingChanged) {
            TEMPORARY.calcMinTaskDays();
            touchedNodes.add(TEMPORARY);
        }
    }

    private static boolean doTheyMatch(DisplayTask dt0, DisplayTask dt1) {
        return dt0.ivTask.ivPseudoID == dt1.ivTask.ivPseudoID && dt0.ivTask.ivObjectID == dt1.ivTask.ivObjectID && AllgUtils.extEquals(dt0.ivTask.ivIssuerGroup, dt1.ivTask.ivIssuerGroup);
    }

    public static String getIDPath(TaskTreeNode cto) {
        StringBuffer msb = new StringBuffer();
        while (cto != null) {
            if (msb.length() != 0) {
                msb.append("|");
            }
            msb.append(cto.ivTitel);
            cto = cto.ivSuperNode;
        }
        return msb.toString();
    }

    public static TreePath findNode(TaskTreeNode root, String gesIDPath) {
        Vector<TaskTreeNode> sammler = new Vector<TaskTreeNode>();
        if (gesIDPath != null) {
            Vector v = new Vector();
            v.addElement(root);
            TaskTreeNode ncto = null;
            Zeile z = new Zeile(gesIDPath, '|');
            int col = z.size() - 1;
            while (col >= 0) {
                String ntit = z.getString(col);
                if (ntit == null) {
                    return null;
                }
                ncto = null;
                if (v == null) {
                    return null;
                }
                Iterator iter = v.iterator();
                while (iter.hasNext()) {
                    TaskTreeNode cto = (TaskTreeNode)iter.next();
                    if (!cto.ivTitel.equals(ntit)) continue;
                    ncto = cto;
                    sammler.add(ncto);
                }
                if (ncto == null) {
                    return null;
                }
                v = ncto.ivKids;
                --col;
            }
            Object[] oarr = new Object[sammler.size()];
            int i = 0;
            while (i < oarr.length) {
                oarr[i] = sammler.elementAt(i);
                ++i;
            }
            return new TreePath(oarr);
        }
        return null;
    }

    public static void clearUnterhaenger() {
        TaskTreeNode.clearUnterhaenger(DONE);
        TaskTreeNode.clearUnterhaenger(IN_PROGRESS);
        TaskTreeNode.clearUnterhaenger(PENDING);
        TaskTreeNode.clearUnterhaenger(REJECTED);
        TaskTreeNode.clearUnterhaenger(WITHDRAWN);
        TaskTreeNode.clearUnterhaenger(UNFINSHED_REMOVED);
        TREE.setModel(new DefaultTreeModel(ROOT));
    }

    private static void clearUnterhaenger(TaskTreeNode node) {
        if (node != null && node.ivKids != null) {
            node.ivKids.clear();
            node.ivKids = null;
        }
    }

    private static Vector insertTask(DisplayTask displayTask, Vector sammler, IDObject corrIDO) {
        if (sammler == null) {
            sammler = new Vector();
        }
        TaskTreeNode ueberNode = null;
        switch (displayTask.ivTask.ivStatus) {
            case 3: {
                ueberNode = DONE;
                break;
            }
            case 2: {
                ueberNode = IN_PROGRESS;
                break;
            }
            case 1: {
                ueberNode = PENDING;
                break;
            }
            case 4: {
                ueberNode = REJECTED;
                break;
            }
            case 5: {
                ueberNode = WITHDRAWN;
                break;
            }
            case 6: {
                ueberNode = UNFINSHED_REMOVED;
                break;
            }
            default: {
                ueberNode = UNKNOWN;
            }
        }
        if (ueberNode != null) {
            if (ueberNode.ivKids == null) {
                ueberNode.ivKids = new Vector();
            }
            if (ueberNode.ivKids.isEmpty()) {
                new TaskTreeNode(Babel.get("TTN_BY_ISSUE_DATE"), ueberNode, null, true);
                new TaskTreeNode(Babel.get("TTN_BY_DUE_DATE"), ueberNode, null, false);
                new TaskTreeNode(Babel.get("TTN_BY_PROCEDURE"), ueberNode, null, false);
                new TaskTreeNode(Babel.get("TTN_BY_RACK"), ueberNode, null, false);
                if (MausoleumClient.isRegularOrTGService()) {
                    new TaskTreeNode(Babel.get("TTN_BY_ROOM"), ueberNode, null, false);
                }
            }
            Integer issueDate = new Integer(Integer.MIN_VALUE);
            Integer tageFuerTitel = null;
            String titel = Babel.get("TASK_UNKNOWN_ISSUE_DATE");
            if (displayTask.ivTask.ivIssueMillis != 0L) {
                int datum = (int)(displayTask.ivTask.ivIssueMillis / 86400000L);
                tageFuerTitel = issueDate = new Integer(datum);
            }
            TaskTreeNode.directSortin((TaskTreeNode)ueberNode.ivKids.elementAt(0), issueDate, issueDate, titel, displayTask, sammler, tageFuerTitel);
            if (displayTask.ivTask.isFixedDayTask()) {
                Integer dueDate = new Integer(displayTask.ivTask.ivDatum);
                TaskTreeNode.directSortin((TaskTreeNode)ueberNode.ivKids.elementAt(1), dueDate, dueDate, titel, displayTask, sammler, dueDate);
            } else if (displayTask.ivTask.isPeriodTask()) {
                if (displayTask.ivTask.ivNextExecDates == null) {
                    displayTask.ivTask.ivNextExecDates = PeriodTaskHelper.getDates(displayTask.ivTask, MyDate.HEUTE);
                }
                Iterator iterator = displayTask.ivTask.ivNextExecDates.iterator();
                while (iterator.hasNext()) {
                    Integer dueDate = (Integer)iterator.next();
                    if (dueDate - MyDate.HEUTE >= 21) continue;
                    TaskTreeNode.directSortin((TaskTreeNode)ueberNode.ivKids.elementAt(1), dueDate, dueDate, titel, displayTask, sammler, dueDate);
                }
            }
            titel = displayTask.ivTask.getDescription(displayTask.getString("IDO_GROUP", ""));
            String comparable = titel.toLowerCase().trim();
            TaskTreeNode.directSortin((TaskTreeNode)ueberNode.ivKids.elementAt(2), (Comparable)((Object)comparable), titel, titel, displayTask, sammler, null);
            Cage cage = null;
            IDObject rack = null;
            if (corrIDO instanceof Mouse) {
                Mouse mouse = (Mouse)corrIDO;
                cage = mouse.getActCage();
            } else if (corrIDO instanceof Cage) {
                cage = (Cage)corrIDO;
            }
            if (cage != null) {
                cage = cage.getSuperCageIfThere();
                rack = cage.getRack();
            }
            String idString = rack != null ? rack.getIdentifierString() : null;
            titel = rack != null ? ((Rack)rack).getBrowseName() : Babel.get("TTN_WITHOUT_RACK");
            comparable = rack != null ? titel.toLowerCase().trim() : null;
            TaskTreeNode.directSortin((TaskTreeNode)ueberNode.ivKids.elementAt(3), (Comparable)((Object)comparable), idString, titel, displayTask, sammler, null);
            if (MausoleumClient.isRegularOrTGService()) {
                Room room = cage != null ? cage.getRoom() : null;
                idString = room != null ? room.getIdentifierString() : null;
                titel = room != null ? room.getBrowseName() : Babel.get("TTN_WITHOUT_ROOM");
                comparable = room != null ? titel.toLowerCase().trim() : null;
                TaskTreeNode.directSortin((TaskTreeNode)ueberNode.ivKids.elementAt(4), (Comparable)((Object)comparable), idString, titel, displayTask, sammler, null);
            }
        }
        return sammler;
    }

    private static void directSortin(TaskTreeNode ueberNode, Comparable comparable, Object findObject, String titel, DisplayTask task, Vector sammler, Integer tageFuerTitel) {
        TaskTreeNode superNode = null;
        if (ueberNode.ivKids != null) {
            Iterator iter = ueberNode.ivKids.iterator();
            while (iter.hasNext() && superNode == null) {
                TaskTreeNode ttn = (TaskTreeNode)iter.next();
                if (findObject == null) {
                    if (ttn.ivFindObject != null) continue;
                    superNode = ttn;
                    continue;
                }
                if (ttn.ivFindObject == null || !ttn.ivFindObject.equals(findObject)) continue;
                superNode = ttn;
            }
        }
        if (superNode == null) {
            if (tageFuerTitel != null) {
                titel = DatumFormat.getJustDateString(tageFuerTitel);
            }
            superNode = new TaskTreeNode(titel, ueberNode, comparable, true);
            superNode.ivTasks = new Vector();
            superNode.ivFindObject = findObject;
        }
        superNode.ivTasks.add(task);
        sammler.add(superNode);
    }

    private static void informListeners() {
        if (!ACTIONLISTENERS.isEmpty()) {
            ActionEvent ae = new ActionEvent(ROOT, 0, TASK_CHANGED);
            Iterator iter = ACTIONLISTENERS.iterator();
            while (iter.hasNext()) {
                ActionListener al = (ActionListener)iter.next();
                al.actionPerformed(ae);
            }
        }
    }

    private TaskTreeNode(String titel, TaskTreeNode superNode, Comparable comparable, boolean calcSumUp) {
        this.ivTitel = titel;
        this.ivSuperNode = superNode;
        this.ivComparable = comparable;
        this.ivCalcSumUp = calcSumUp;
        if (this.ivSuperNode != null) {
            if (this.ivSuperNode.ivKids == null) {
                this.ivSuperNode.ivKids = new Vector();
            }
            this.ivSuperNode.ivKids.add(this);
            if (this.ivSuperNode.ivKids.size() > 1) {
                Collections.sort(this.ivSuperNode.ivKids, NODE_COMPARER);
            }
        }
    }

    public String toString() {
        StringBuffer msb = new StringBuffer(this.ivTitel);
        msb.append(" [").append(this.countTasks()).append("]");
        return msb.toString();
    }

    public boolean isUnder(TaskTreeNode ttn) {
        if (this == ttn) {
            return true;
        }
        return this.ivSuperNode != null ? this.ivSuperNode.isUnder(ttn) : false;
    }

    private void calcMinTaskDays() {
        Iterator iter;
        this.ivMinDay = Integer.MAX_VALUE;
        if (this.ivTasks != null) {
            iter = this.ivTasks.iterator();
            while (iter.hasNext()) {
                DisplayTask task = (DisplayTask)iter.next();
                int tdays = task.ivTask.getMinimumDays(MyDate.HEUTE);
                if (task.ivTask.isFinished() || tdays >= this.ivMinDay) continue;
                this.ivMinDay = tdays;
                if (this.ivSuperNode == null) continue;
                this.ivSuperNode.calcMinTaskDays();
            }
        }
        if (this.ivKids != null) {
            iter = this.ivKids.iterator();
            while (iter.hasNext()) {
                TaskTreeNode ttn = (TaskTreeNode)iter.next();
                if (ttn.ivMinDay >= this.ivMinDay) continue;
                this.ivMinDay = ttn.ivMinDay;
            }
        }
    }

    public void removeAllTasks() {
        if (this.ivKids != null) {
            Iterator iter = this.ivKids.iterator();
            while (iter.hasNext()) {
                TaskTreeNode ttn = (TaskTreeNode)iter.next();
                ttn.removeAllTasks();
            }
        }
        if (this.ivTasks != null) {
            this.ivTasks.clear();
        }
        this.calcMinTaskDays();
    }

    public int countTasks() {
        int sum = 0;
        if (this.ivKids != null) {
            Iterator iter = this.ivKids.iterator();
            while (iter.hasNext()) {
                TaskTreeNode ttn = (TaskTreeNode)iter.next();
                if (!ttn.ivCalcSumUp) continue;
                sum += ttn.countTasks();
            }
        }
        if (this.ivTasks != null) {
            sum += this.ivTasks.size();
        }
        this.ivLastCalcedSum = sum;
        return sum;
    }

    public void collectTasks(Vector target) {
        if (this.ivKids != null) {
            Iterator iter = this.ivKids.iterator();
            while (iter.hasNext()) {
                TaskTreeNode ttn = (TaskTreeNode)iter.next();
                if (!ttn.ivCalcSumUp) continue;
                ttn.collectTasks(target);
            }
        }
        if (this.ivTasks != null) {
            target.addAll(this.ivTasks);
        }
    }

    private void collectTasksWithPseudoID(Vector target, LongPunkt taskGroupIdentifier, String group, int typ, HashSet objectIDs) {
        if (this.ivKids != null) {
            Iterator iter = this.ivKids.iterator();
            while (iter.hasNext()) {
                TaskTreeNode ttn = (TaskTreeNode)iter.next();
                if (!ttn.ivCalcSumUp) continue;
                ttn.collectTasksWithPseudoID(target, taskGroupIdentifier, group, typ, objectIDs);
            }
        }
        if (this.ivTasks != null) {
            Iterator iterator = this.ivTasks.iterator();
            while (iterator.hasNext()) {
                Long key;
                DisplayTask dt = (DisplayTask)iterator.next();
                if (dt.ivComeFromType != typ || !group.equals(dt.getGroup()) || dt.ivTask.ivStatus != 1 || !dt.ivTask.belongsToTaskGroup(taskGroupIdentifier) || objectIDs.contains(key = new Long(dt.ivTask.ivObjectID))) continue;
                target.add(dt);
                objectIDs.add(key);
            }
        }
    }

    private void collectTasks(HashMap target, HashMap displayTasksByID_CF, String group, long objectID, int objectType) {
        Iterator iter;
        if (this == TEMPORARY) {
            return;
        }
        if (this.ivKids != null) {
            iter = this.ivKids.iterator();
            while (iter.hasNext()) {
                TaskTreeNode ttn = (TaskTreeNode)iter.next();
                if (!ttn.ivCalcSumUp) continue;
                ttn.collectTasks(target, displayTasksByID_CF, group, objectID, objectType);
            }
        }
        if (this.ivTasks != null) {
            iter = this.ivTasks.iterator();
            while (iter.hasNext()) {
                DisplayTask task = (DisplayTask)iter.next();
                if (!group.equals(task.getGroup())) continue;
                Long key = new Long(task.ivTask.ivPseudoID);
                if (target != null) {
                    target.put(key, task);
                }
                if (displayTasksByID_CF == null || task.ivComeFromID != objectID || task.ivComeFromType != objectType) continue;
                displayTasksByID_CF.put(key, task);
            }
        }
    }

    private Vector removeTask(DisplayTask task, Vector sammler) {
        Iterator iter;
        if (sammler == null) {
            sammler = new Vector<TaskTreeNode>();
        }
        if (this.ivKids != null) {
            Vector<TaskTreeNode> emptyNodes = new Vector<TaskTreeNode>();
            iter = this.ivKids.iterator();
            while (iter.hasNext()) {
                TaskTreeNode ttn = (TaskTreeNode)iter.next();
                ttn.removeTask(task, sammler);
                if (ttn.ivTasks == null || !ttn.ivTasks.isEmpty()) continue;
                emptyNodes.add(ttn);
            }
            Iterator iterator = emptyNodes.iterator();
            while (iterator.hasNext()) {
                TaskTreeNode emptyNode = (TaskTreeNode)iterator.next();
                this.ivKids.remove(emptyNode);
                emptyNode.ivSuperNode = null;
                emptyNode.ivTasks = null;
            }
        }
        if (this.ivTasks != null) {
            DisplayTask toRemove = null;
            iter = this.ivTasks.iterator();
            while (iter.hasNext()) {
                DisplayTask dt = (DisplayTask)iter.next();
                if (dt.ivTask.ivPseudoID != task.ivTask.ivPseudoID) continue;
                toRemove = dt;
            }
            if (toRemove != null) {
                this.ivTasks.remove(toRemove);
                sammler.add(this);
            }
        }
        return sammler;
    }

    public Enumeration children() {
        if (this.ivKids != null) {
            return this.ivKids.elements();
        }
        return null;
    }

    public boolean getAllowsChildren() {
        return this.ivKids != null;
    }

    public TreeNode getChildAt(int childIndex) {
        if (this.ivKids != null && childIndex < this.ivKids.size()) {
            return (TreeNode)this.ivKids.elementAt(childIndex);
        }
        return null;
    }

    public int getChildCount() {
        if (this.ivKids != null) {
            return this.ivKids.size();
        }
        return 0;
    }

    public int getIndex(TreeNode node) {
        if (this.ivKids != null) {
            return this.ivKids.indexOf(node);
        }
        return -1;
    }

    public TreeNode getParent() {
        return this.ivSuperNode;
    }

    public boolean isLeaf() {
        return !this.getAllowsChildren();
    }
}

