/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.task.standards;

import de.hannse.netobjects.util.Babel;
import java.awt.Frame;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import mausoleum.helper.FontManager;
import mausoleum.inspector.Inspector;
import mausoleum.mouse.TaskExtended;
import mausoleum.requester.BasicRequester;
import mausoleum.task.standards.StandardTask;
import mausoleum.ui.UIDef;

public class CombiTaskRequester
extends BasicRequester {
    private static final long serialVersionUID = 1L;
    private static final int LABEL_WIDTH = UIDef.getScaled(150);
    private static final int LABEL_X = UIDef.RAND;
    private static final int COMBO_WIDTH_1 = UIDef.getScaled(120);
    private static final int COMBO_X_1 = LABEL_X + LABEL_WIDTH + UIDef.INNER_RAND;
    private static final int COMBO_WIDTH_2 = UIDef.getScaled(120);
    private static final int COMBO_X_2 = COMBO_X_1 + COMBO_WIDTH_1 + UIDef.INNER_RAND;
    private static final int BREITE = COMBO_X_2 + COMBO_WIDTH_2 + UIDef.RAND;
    private static final int HOEHE = UIDef.getScaled(300);
    private static final Integer[] OFFSET_TAGE = new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(5), new Integer(6), new Integer(7), new Integer(8), new Integer(9), new Integer(10), new Integer(11), new Integer(12), new Integer(13), new Integer(14), new Integer(15), new Integer(16), new Integer(17), new Integer(18), new Integer(19), new Integer(20), new Integer(21), new Integer(22), new Integer(23), new Integer(24), new Integer(25), new Integer(26), new Integer(27), new Integer(28), new Integer(29), new Integer(30)};
    private JTextField ivDescrField = new JTextField();
    private Vector ivTaskLines = new Vector();

    public static void createNewCombiTask(Vector standardTasks, String group) {
        CombiTaskRequester ctr = new CombiTaskRequester(standardTasks, group, null);
        if (ctr.ivWarOK) {
            int anzCombis = ctr.ivTaskLines.size();
            int[] combiIDs = new int[anzCombis];
            int[] combiDayOffsets = new int[anzCombis];
            int[] combiTimePrefs = new int[anzCombis];
            int i = 0;
            while (i < anzCombis) {
                TaskZeile tz = (TaskZeile)ctr.ivTaskLines.elementAt(i);
                combiIDs[i] = tz.ivTaskID;
                combiDayOffsets[i] = (Integer)tz.ivDayOffsetCombo.getSelectedItem();
                combiTimePrefs[i] = TaskExtended.TIME_INTS[tz.ivTimePrefCombo.getSelectedIndex()];
                ++i;
            }
            StandardTask.insertCombiStandardTask(ctr.ivDescrField.getText().trim(), StandardTask.getSexRestrictionForCombinedTaskCreation(standardTasks), "TASK_DATE_FIX", "TASK_AC_NONE", group, combiIDs, combiDayOffsets, combiTimePrefs, StandardTask.getSingleGroupRestrictionForCombinedTaskCreation(standardTasks), -1, -1);
        }
    }

    public static void modifyCombiTask(StandardTask original, String group) {
        CombiTaskRequester ctr = new CombiTaskRequester(null, group, original);
        if (ctr.ivWarOK) {
            int anzCombis = ctr.ivTaskLines.size();
            int[] combiIDs = new int[anzCombis];
            int[] combiDayOffsets = new int[anzCombis];
            int[] combiTimePrefs = new int[anzCombis];
            int i = 0;
            while (i < anzCombis) {
                TaskZeile tz = (TaskZeile)ctr.ivTaskLines.elementAt(i);
                combiIDs[i] = tz.ivTaskID;
                combiDayOffsets[i] = (Integer)tz.ivDayOffsetCombo.getSelectedItem();
                combiTimePrefs[i] = TaskExtended.TIME_INTS[tz.ivTimePrefCombo.getSelectedIndex()];
                ++i;
            }
            StandardTask.changeCombiStandardTask(original.ivID, ctr.ivDescrField.getText().trim(), original.ivSexRestriction, "TASK_DATE_FIX", original.ivAutocompletion, original.ivVisible, group, combiIDs, combiDayOffsets, combiTimePrefs, original.ivSingleGroupOnly, original.ivMinimumAge, original.ivMaximumAge);
        }
    }

    private CombiTaskRequester(Vector standardTasks, String group, StandardTask original) {
        super((Frame)Inspector.getInspector(), BREITE, HOEHE);
        this.setTitle(Babel.get("CREATE_TASK_BUNDLE"));
        int y = UIDef.RAND;
        this.addAndApplyBounds(new JLabel(Babel.get("TASK_DESCRIPTION")), LABEL_X, y, LABEL_WIDTH, UIDef.LINE_HEIGHT);
        if (original != null) {
            this.ivDescrField.setText(original.ivDescrBabel);
        }
        this.addAndApplyBounds(this.ivDescrField, COMBO_X_1, y, COMBO_WIDTH_1 + UIDef.INNER_RAND + COMBO_WIDTH_2, UIDef.LINE_HEIGHT);
        JLabel lab = new JLabel(Babel.get("CTR_TASK"), 2);
        lab.setFont(FontManager.getFont("SSP11"));
        this.addAndApplyBounds(lab, LABEL_X, y += UIDef.LINE_HEIGHT + UIDef.RAND, LABEL_WIDTH, UIDef.LINE_HEIGHT);
        lab = new JLabel(Babel.get("CTR_DAY_OFFSET"), 0);
        lab.setFont(FontManager.getFont("SSP11"));
        this.addAndApplyBounds(lab, COMBO_X_1, y, COMBO_WIDTH_1, UIDef.LINE_HEIGHT);
        lab = new JLabel(Babel.get("CTR_TIME"), 0);
        lab.setFont(FontManager.getFont("SSP11"));
        this.addAndApplyBounds(lab, COMBO_X_2, y, COMBO_WIDTH_2, UIDef.LINE_HEIGHT);
        y += UIDef.LINE_HEIGHT + UIDef.RAND;
        if (original != null) {
            int i = 0;
            while (i < original.ivCombiIDs.length) {
                TaskZeile tz = new TaskZeile(original.ivCombiIDs[i], original.ivCombiDayOffsets[i], original.ivCombiTimePrefs[i], group);
                this.ivTaskLines.addElement(tz);
                this.addAndApplyBounds(tz.ivTaskNameLabel, LABEL_X, y, LABEL_WIDTH, UIDef.LINE_HEIGHT);
                this.addAndApplyBounds(tz.ivDayOffsetCombo, COMBO_X_1, y, COMBO_WIDTH_1, UIDef.LINE_HEIGHT);
                this.addAndApplyBounds(tz.ivTimePrefCombo, COMBO_X_2, y, COMBO_WIDTH_2, UIDef.LINE_HEIGHT);
                y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND;
                ++i;
            }
        } else {
            Iterator iter = standardTasks.iterator();
            while (iter.hasNext()) {
                StandardTask st = (StandardTask)iter.next();
                TaskZeile tz = new TaskZeile(st, group);
                this.ivTaskLines.addElement(tz);
                this.addAndApplyBounds(tz.ivTaskNameLabel, LABEL_X, y, LABEL_WIDTH, UIDef.LINE_HEIGHT);
                this.addAndApplyBounds(tz.ivDayOffsetCombo, COMBO_X_1, y, COMBO_WIDTH_1, UIDef.LINE_HEIGHT);
                this.addAndApplyBounds(tz.ivTimePrefCombo, COMBO_X_2, y, COMBO_WIDTH_2, UIDef.LINE_HEIGHT);
                y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND;
            }
        }
        this.ivDescrField.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                CombiTaskRequester.this.ivOkButton.setEnabled(CombiTaskRequester.this.ivDescrField.getText().trim().length() != 0);
            }
        });
        this.ivOkButton.setEnabled(this.ivDescrField.getText().trim().length() != 0);
        this.applyBounds(this.ivOkButton, UIDef.RAND, y += UIDef.RAND - UIDef.INNER_RAND, BREITE - 2 * UIDef.RAND, UIDef.BUT_HEIGHT);
        this.setInnerSize(BREITE, y += UIDef.BUT_HEIGHT + UIDef.RAND);
        this.setVisible(true);
    }

    public void OKPressed() {
        if (this.ivDescrField.getText().trim().length() != 0) {
            super.OKPressed();
        }
    }

    public boolean okAndNoWanted() {
        return false;
    }

    public boolean onlyOKWanted() {
        return true;
    }

    static /* synthetic */ Integer[] access$0() {
        return OFFSET_TAGE;
    }

    class TaskZeile {
        private final int ivTaskID;
        private final JLabel ivTaskNameLabel;
        private JComboBox ivDayOffsetCombo = new JComboBox<Integer>(CombiTaskRequester.access$0());
        private JComboBox ivTimePrefCombo = new JComboBox<String>(Babel.get(TaskExtended.TIME_STRINGS, true));

        private TaskZeile(StandardTask ts, String group) {
            this.ivTaskID = ts.ivID;
            this.ivTaskNameLabel = new JLabel(StandardTask.getDescription(group, this.ivTaskID, "", true, null));
        }

        private TaskZeile(int id, int dayOffset, int timepref, String group) {
            this.ivTaskID = id;
            this.ivTaskNameLabel = new JLabel(StandardTask.getDescription(group, this.ivTaskID, "", true, null));
            this.ivDayOffsetCombo.setSelectedItem(new Integer(dayOffset));
            int i = 0;
            while (i < TaskExtended.TIME_INTS.length) {
                if (TaskExtended.TIME_INTS[i] == timepref) {
                    this.ivTimePrefCombo.setSelectedIndex(i);
                }
                ++i;
            }
        }
    }
}

