/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.task.standards;

import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.network.client.NetReceiverClientCommandManager;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MilliSpender;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.cage.CageManager;
import mausoleum.helper.Zeile;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.TaskExtended;
import mausoleum.mouse.tierschutz.TierSchutz;
import mausoleum.task.DisplayTask;

public class StandardTask
extends IDObject {
    private static final long serialVersionUID = 1234353453L;
    public static final String TASK_SEX_MALE = "TASK_SEX_MALE";
    public static final String TASK_SEX_FEMALE = "TASK_SEX_FEMALE";
    public static final String TASK_SEX_UNSET = "TASK_SEX_UNSET";
    public static final String TASK_SEX_ANY = "TASK_SEX_ANY";
    public static final String TASK_SEX_MATING = "TASK_SEX_MATING";
    public static final String TASK_DATE_FIX = "TASK_DATE_FIX";
    public static final String TASK_DATE_PERIOD = "TASK_DATE_PERIOD";
    public static final String TASK_DATE_ANY = "TASK_DATE_ANY";
    public static final String TASK_SINGLE_GROUP = "TASK_SINGLE_GROUP";
    public static final String TASK_AC_NONE = "TASK_AC_NONE";
    public static final String TASK_AC_EARTAG = "TASK_AC_EARTAG";
    public static final String TASK_AC_KILL = "TASK_AC_KILL";
    public static final String TASK_AC_TRANSFER = "TASK_AC_TRANSFER";
    public static final String TASK_AC_GENOTYPE = "TASK_AC_GENOTYPE";
    public static final String TASK_AC_PLUGDATE = "TASK_AC_PLUGDATE";
    public static final String TASK_AC_SEX = "TASK_AC_SEX";
    public static final String TASK_AC_TO_MATING = "TASK_AC_TO_MATING";
    public static final String TASK_AC_RESULT = "TASK_AC_RESULT";
    public static final String TASK_AC_ROOMTRANSFER = "TASK_AC_ROOMTRANSFER";
    public static final String TASK_AC_PRECISE_POOLING = "TASK_AC_PRECISE_POOLING";
    public static final String TASK_AC_RUDELBUMS = "TASK_AC_RUDELBUMS";
    public static final String TASK_AC_MATING_END = "TASK_AC_MATING_END";
    public static final String[] SEX_RESTRICTIONS = new String[]{"TASK_SEX_ANY", "TASK_SEX_MALE", "TASK_SEX_FEMALE", "TASK_SEX_UNSET", "TASK_SEX_MATING"};
    public static final String[] SEX_RESTRICTIONS_DISPLAY = new String[]{Babel.get("TASK_SEX_ANY"), Babel.get("TASK_SEX_MALE"), Babel.get("TASK_SEX_FEMALE"), Babel.get("TASK_SEX_UNSET"), Babel.get("TASK_SEX_MATING")};
    public static final String[] DATE_RESTRICTIONS = new String[]{"TASK_DATE_ANY", "TASK_DATE_FIX", "TASK_DATE_PERIOD"};
    public static final String[] DATE_RESTRICTIONS_DISPLAY = new String[]{Babel.get("TASK_DATE_ANY"), Babel.get("TASK_DATE_FIX"), Babel.get("TASK_DATE_PERIOD")};
    public static final String[] AUTO_COMPLETIONS = new String[]{"TASK_AC_NONE", "TASK_AC_EARTAG", "TASK_AC_KILL", "TASK_AC_TRANSFER", "TASK_AC_GENOTYPE", "TASK_AC_PLUGDATE", "TASK_AC_SEX", "TASK_AC_TO_MATING", "TASK_AC_RESULT", "TASK_AC_ROOMTRANSFER", "TASK_AC_PRECISE_POOLING"};
    public static final String[] AUTO_COMPLETIONS_DISPLAY = new String[]{Babel.get("TASK_AC_NONE"), Babel.get("TASK_AC_EARTAG"), Babel.get("TASK_AC_KILL"), Babel.get("TASK_AC_TRANSFER"), Babel.get("TASK_AC_GENOTYPE"), Babel.get("TASK_AC_PLUGDATE"), Babel.get("TASK_AC_SEX"), Babel.get("TASK_AC_TO_MATING"), Babel.get("TASK_AC_RESULT"), Babel.get("TASK_AC_ROOMTRANSFER"), Babel.get("TASK_AC_PRECISE_POOLING")};
    public static final String[] AUTO_COMPLETIONS_HEAD_OF_SERVICE = new String[]{"TASK_AC_NONE", "TASK_AC_EARTAG", "TASK_AC_KILL", "TASK_AC_TRANSFER", "TASK_AC_GENOTYPE", "TASK_AC_PLUGDATE", "TASK_AC_SEX", "TASK_AC_TO_MATING", "TASK_AC_RESULT", "TASK_AC_ROOMTRANSFER", "TASK_AC_PRECISE_POOLING"};
    public static final String[] AUTO_COMPLETIONS_DISPLAY_HEAD_OF_SERVICE = new String[]{Babel.get("TASK_AC_NONE"), Babel.get("TASK_AC_EARTAG"), Babel.get("TASK_AC_KILL"), Babel.get("TASK_AC_TRANSFER"), Babel.get("TASK_AC_GENOTYPE"), Babel.get("TASK_AC_PLUGDATE"), Babel.get("TASK_AC_SEX"), Babel.get("TASK_AC_TO_MATING"), Babel.get("TASK_AC_RESULT"), Babel.get("TASK_AC_ROOMTRANSFER"), Babel.get("TASK_AC_PRECISE_POOLING")};
    public static final String[] PERFORM_ONLYS = new String[]{"TASK_AC_RUDELBUMS", "TASK_AC_RESULT"};
    public static final int MIN_GROUP_STANDARD_ID = 1001;
    public static final int MIN_SERVICE_STANDARD_ID = 5001;
    public static final String SYSTEM_MARK = "[M] ";
    public static final String SERVICE_MARK = "[S] ";
    public static final String GROUP_MARK = "[G] ";
    private static final String HEADER_ID = "ID";
    private static final String HEADER_DESCR = "DESCRIPTION";
    private static final String HEADER_SEX_RESTR = "SEX_RESTRICTION";
    private static final String HEADER_AUTO_COMPL = "AUTO_COMPLETION";
    private static final String HEADER_VISIBLE = "VISIBLE";
    private static final String HEADER_COMBI_INFO = "COMBI_INFO";
    private static final String HEADER_COLOR = "COLOR";
    private static final String HEADER_MINIMUM_AGE = "MINIMUM_AGE";
    private static final String HEADER_MAXIMUM_AGE = "MAXIMUM_AGE";
    private static final String[] EXCEL_HEADERS = new String[]{"ID", "DESCRIPTION", "SEX_RESTRICTION", "AUTO_COMPLETION", "VISIBLE", "COMBI_INFO", "COLOR", "MINIMUM_AGE", "MAXIMUM_AGE"};
    private static final int COL_ID = 0;
    private static final int COL_DESCR = 1;
    private static final int COL_SEX_RESTR = 2;
    private static final int COL_AUTO_COMPL = 3;
    private static final int COL_VISIBLE = 4;
    private static final int COL_COMBI_DATA = 5;
    private static final int COL_COLOR = 6;
    private static final int COL_WORKFLOW = 7;
    private static final int COL_MINIMUM_AGE = 8;
    private static final int COL_MAXIMUM_AGE = 9;
    private static final String TRENNER = "|";
    private static final char TRENNER_CHAR = '|';
    private static final String TRENNER2 = "@";
    private static final char TRENNER2_CHAR = '@';
    public static final String EXCEL_SHEET_NAME = "standard_tasks";
    private static final HashMap SYSTEM_STANDARDS_BY_ID = new HashMap(100);
    private static final HashMap GROUP_STANDARDS_BY_GROUP = new HashMap();
    public static final long NO_ADDITIONAL_ID = -1L;
    public static final int SYSTEM_TASK_EARTAG = 1;
    public static final int SYSTEM_TASK_KILL = 2;
    public static final int SYSTEM_TASK_CUT_TAIL = 3;
    public static final int SYSTEM_TASK_TRANSFER = 4;
    public static final int SYSTEM_TASK_GENOTYPE = 5;
    public static final int SYSTEM_TASK_PLUGCHECK = 6;
    public static final int SYSTEM_TASK_CHECKSEX = 7;
    public static final int SYSTEM_TASK_HEALTH_REPORT = 8;
    public static final int SYSTEM_TASK_MASS_MATING = 9;
    public static final int SYSTEM_TASK_END_MATING = 10;
    public static final int SYSTEM_TASK_ABSETZ_REPORT = 100;
    public static final int SYSTEM_TASK_EINZELTIER_REPORT = 101;
    private static final String[] SYSTEM_TASK_DEF_LINES = new String[]{"1|TASK_STD_EARTAG|TASK_SEX_ANY@TASK_DATE_FIX|TASK_AC_EARTAG|1||", "2|TASK_STD_KILL|TASK_SEX_ANY@TASK_DATE_FIX|TASK_AC_KILL|1||250,0,0", "3|TASK_STD_CUT_TAIL|TASK_SEX_ANY@TASK_DATE_FIX|TASK_AC_NONE|1||", "4|TASK_STD_TRANSFER|TASK_SEX_ANY@TASK_DATE_FIX|TASK_AC_TRANSFER|1||0,210,0", "5|TASK_STD_GENOTYPE|TASK_SEX_ANY@TASK_DATE_FIX|TASK_AC_GENOTYPE|1||", "6|TASK_STD_PLUGCHECK|TASK_SEX_FEMALE|TASK_AC_PLUGDATE|1||", "7|TASK_STD_CHECKSEX|TASK_SEX_UNSET|TASK_AC_SEX|1||", "8|TASK_STD_HEALTH_REPORT|TASK_SEX_ANY|TASK_AC_RESULT@-42|1||", "9|TASK_STD_MASS_MATING|TASK_SEX_MATING@TASK_DATE_FIX@TASK_SINGLE_GROUP|TASK_AC_RUDELBUMS|1||230,220,80", "10|TASK_STD_END_MATING|TASK_SEX_ANY@TASK_DATE_FIX|TASK_AC_MATING_END|1||80,220,230"};
    public static final String[] SYSTEM_TASK_DEF_TIERSCHUTZ_LINES_D = new String[]{"100|TASK_TS_EVAL_D1_ABSETZBEURTEILUNG|TASK_SEX_ANY@TASK_DATE_FIX|TASK_AC_RESULT@-44|1||150,220,230", "101|TASK_TS_EVAL_D1_BEURTEILUNG_EINZELTIER|TASK_SEX_ANY@TASK_DATE_PERIOD|TASK_AC_RESULT@-45|1||150,230,220"};
    private static final String[] AUTO_COMPLETERS_ALSO_IN_PERIOD = new String[]{"TASK_AC_PLUGDATE", "TASK_AC_SEX", "TASK_AC_RESULT"};
    public static final HashMap PREF_PER_FREQS_BY_SYSTEM_TASK_ID = new HashMap();
    public static final HashMap PREF_PER_ENDS_BY_SYSTEM_TASK_ID = new HashMap();
    public final int ivID;
    public final String ivDescrBabel;
    public final String ivSexRestriction;
    public final String ivDateRestriction;
    public final String ivAutocompletion;
    public boolean ivVisible;
    public final boolean ivChangeable;
    public final boolean ivSingleGroupOnly;
    public long ivAdditionalObjectID = -1L;
    public final int[] ivCombiIDs;
    public final int[] ivCombiDayOffsets;
    public final int[] ivCombiTimePrefs;
    public Color ivTriangleColor = null;
    public String ivWorkFlowDef = null;
    public int ivPrefPeriodFreq = 0;
    public int ivMinimumAge = -1;
    public int ivMaximumAge = -1;

    public static void init(String group) {
        if (SYSTEM_STANDARDS_BY_ID.isEmpty()) {
            int i = 0;
            while (i < SYSTEM_TASK_DEF_LINES.length) {
                StandardTask.handleLine(SYSTEM_TASK_DEF_LINES[i], group);
                ++i;
            }
            String[] specLines = TierSchutz.getSpecialTaskDefLines();
            if (specLines != null && specLines.length != 0) {
                int i2 = 0;
                while (i2 < specLines.length) {
                    StandardTask.handleLine(specLines[i2], group);
                    ++i2;
                }
            }
            TierSchutz.fillPeriodPrefsOfSystemTasks(PREF_PER_FREQS_BY_SYSTEM_TASK_ID, PREF_PER_ENDS_BY_SYSTEM_TASK_ID);
        }
        GROUP_STANDARDS_BY_GROUP.remove(group);
        StandardTask.handleFile(FileManager.getStringContentFromServer(GroupFileManager.getStandardTaskPath(group)), group);
    }

    public static void clearGroupHashMaps() {
        GROUP_STANDARDS_BY_GROUP.clear();
    }

    public static boolean reinitForCommand(String command) {
        Zeile z = new Zeile(command, '|');
        String group = z.getString(1);
        if (group != null) {
            StandardTask.init(group);
            return true;
        }
        return false;
    }

    private static final void handleFile(String s, String group) {
        if (s != null) {
            Vector lines = StringHelper.splitStringByAny(s, "\n");
            Iterator iter = lines.iterator();
            while (iter.hasNext()) {
                StandardTask.handleLine((String)iter.next(), group);
            }
        }
    }

    private static final void handleLine(String line, String group) {
        if (line != null && (line = line.trim()).length() != 0 && !line.startsWith("#")) {
            new StandardTask(line, group);
        }
    }

    public static void insertNewStandardTask(String descr, String sexRestriction, String dateRestriction, String autoCompletion, Color triangleColor, String group, long additionalObjectID, boolean singleGroupOnly, int minimumAge, int maximumAge) {
        new StandardTask(descr, sexRestriction, dateRestriction, autoCompletion, triangleColor, group, null, null, null, additionalObjectID, singleGroupOnly, minimumAge, maximumAge);
        StandardTask.saveStandardsToServer(group);
    }

    public static void insertCombiStandardTask(String descr, String sexRestriction, String dateRestriction, String autoCompletion, String group, int[] combiIDs, int[] combiDayOffsets, int[] combiTimePrefs, boolean singleGroupOnly, int minimumAge, int maximumAge) {
        new StandardTask(descr, sexRestriction, dateRestriction, autoCompletion, null, group, combiIDs, combiDayOffsets, combiTimePrefs, 0L, singleGroupOnly, minimumAge, maximumAge);
        StandardTask.saveStandardsToServer(group);
    }

    public static void changeStandardTask(int id, String descr, String sexRestriction, String dateRestriction, String autoCompletion, Color triangleColor, boolean visible, String group, long additionalObjectID, boolean singleGroupOnly, int minimumAge, int maximumAge) {
        new StandardTask(id, descr, sexRestriction, dateRestriction, autoCompletion, triangleColor, visible, group, null, null, null, additionalObjectID, singleGroupOnly, minimumAge, maximumAge);
        StandardTask.saveStandardsToServer(group);
    }

    public static void changeCombiStandardTask(int id, String descr, String sexRestriction, String dateRestriction, String autoCompletion, boolean visible, String group, int[] combiIDs, int[] combiDayOffsets, int[] combiTimePrefs, boolean singleGroupOnly, int minimumAge, int maximumAge) {
        new StandardTask(id, descr, sexRestriction, dateRestriction, autoCompletion, null, visible, group, combiIDs, combiDayOffsets, combiTimePrefs, 0L, singleGroupOnly, minimumAge, maximumAge);
        StandardTask.saveStandardsToServer(group);
    }

    public static void setVisibilityOfStandardTask(int id, String group, boolean visible) {
        StandardTask st = StandardTask.findTask(group, id);
        if (st != null) {
            if (st.isSystemTask()) {
                if (st.ivVisible != visible) {
                    st.ivVisible = visible;
                    st.setBoolean("IDO_VISIBLE", visible);
                    StandardTask.saveStandardsToServer("service");
                }
            } else {
                new StandardTask(id, st.ivDescrBabel, st.ivSexRestriction, st.ivDateRestriction, st.ivAutocompletion, st.ivTriangleColor, visible, group, st.ivCombiIDs, st.ivCombiDayOffsets, st.ivCombiTimePrefs, st.ivAdditionalObjectID, st.ivSingleGroupOnly, st.ivMinimumAge, st.ivMaximumAge);
                StandardTask.saveStandardsToServer(group);
            }
        }
    }

    public static boolean isSystemTask(int proctype) {
        return proctype < 1001;
    }

    public static boolean isInstituteTask(int proctype) {
        return proctype >= 5001;
    }

    public static boolean isGroupTask(int proctype) {
        return proctype >= 1001 && proctype < 5001;
    }

    public static boolean isPureDoer(Vector idObjects, String commonGroup) {
        int i = 0;
        while (i < idObjects.size()) {
            StandardTask st;
            DisplayTask dt = (DisplayTask)idObjects.elementAt(i);
            if (dt.ivTask.ivProcType != -1 && (st = StandardTask.findTask(commonGroup, dt.ivTask.ivProcType)) != null && ArrayHelper.contained(st.ivAutocompletion, PERFORM_ONLYS)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isPurePerfomer(Vector idObjects, String commonGroup) {
        int i = 0;
        while (i < idObjects.size()) {
            DisplayTask dt = (DisplayTask)idObjects.elementAt(i);
            if (dt.ivTask.ivProcType == -1) return false;
            StandardTask st = StandardTask.findTask(commonGroup, dt.ivTask.ivProcType);
            if (st == null) return false;
            if (!ArrayHelper.contained(st.ivAutocompletion, PERFORM_ONLYS)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static void saveStandardsToServer(String group) {
        if (!ProcessDefinition.isServer()) {
            HashMap hm;
            StringBuilder msb = new StringBuilder();
            if ("service".equals(group)) {
                Iterator iter = SYSTEM_STANDARDS_BY_ID.values().iterator();
                while (iter.hasNext()) {
                    ((StandardTask)iter.next()).appendConfigLine(msb);
                }
            }
            if ((hm = (HashMap)GROUP_STANDARDS_BY_GROUP.get(group)) != null && !hm.isEmpty()) {
                Iterator iter = hm.values().iterator();
                while (iter.hasNext()) {
                    ((StandardTask)iter.next()).appendConfigLine(msb);
                }
            }
            if (msb.length() != 0) {
                NetReceiverClientCommandManager.saveContentToServer("COM_STANDARD_TASKS_CHANGED", group, GroupFileManager.getStandardTaskPath(group), msb.toString());
            }
            msb.setLength(0);
            Object var1_1 = null;
        }
    }

    public static String getSexRestrictionForCombinedTaskCreation(Vector selectedStandardTasks) {
        String res = null;
        if (selectedStandardTasks != null && selectedStandardTasks.size() > 1) {
            HashSet<String> hs = new HashSet<String>();
            Iterator iter = selectedStandardTasks.iterator();
            while (iter.hasNext()) {
                StandardTask st = (StandardTask)iter.next();
                if (!st.isPrimaerTask()) {
                    return null;
                }
                String sexRestr = st.ivSexRestriction;
                if (sexRestr == null) {
                    sexRestr = TASK_SEX_ANY;
                }
                hs.add(sexRestr);
            }
            if (hs.size() == 1) {
                res = (String)hs.iterator().next();
            } else if (hs.size() == 2 && hs.contains(TASK_SEX_ANY)) {
                if (hs.contains(TASK_SEX_MALE)) {
                    res = TASK_SEX_MALE;
                } else if (hs.contains(TASK_SEX_FEMALE)) {
                    res = TASK_SEX_FEMALE;
                } else if (hs.contains(TASK_SEX_UNSET)) {
                    res = TASK_SEX_UNSET;
                }
            }
        }
        return res;
    }

    public static boolean getSingleGroupRestrictionForCombinedTaskCreation(Vector selectedStandardTasks) {
        boolean res = false;
        if (selectedStandardTasks != null && selectedStandardTasks.size() > 1) {
            Iterator iter = selectedStandardTasks.iterator();
            while (iter.hasNext()) {
                StandardTask st = (StandardTask)iter.next();
                if (!st.isPrimaerTask()) {
                    return false;
                }
                if (!st.ivSingleGroupOnly) continue;
                res = true;
            }
        }
        return res;
    }

    public static Object[] getComboFeeders(Vector objects, int objectType, String commonGroup) {
        Object[] res = null;
        if (objectType == 1) {
            res = StandardTask.getComboFeedersForMice(objects, commonGroup);
        }
        if (res == null) {
            res = new Object[]{new int[]{-1}, new String[]{" " + Babel.get("TASK_STD_OTHER") + " "}};
        }
        return res;
    }

    private static Object[] getComboFeedersForMice(Vector mice, String commonGroup) {
        HashSet<String> groups = new HashSet<String>();
        int maleCount = 0;
        int femaleCount = 0;
        int unsetCount = 0;
        if (mice != null && !mice.isEmpty()) {
            Iterator iter = mice.iterator();
            while (iter.hasNext()) {
                Mouse mouse = (Mouse)iter.next();
                groups.add(mouse.getGroup(""));
                switch (mouse.getSex()) {
                    case 1: {
                        ++maleCount;
                        break;
                    }
                    case 2: {
                        ++femaleCount;
                        break;
                    }
                    default: {
                        ++unsetCount;
                    }
                }
            }
        } else {
            groups.add(commonGroup);
        }
        TreeMap tm = new TreeMap();
        StandardTask.fillPossStandards(SYSTEM_STANDARDS_BY_ID, maleCount, femaleCount, unsetCount, tm, commonGroup);
        if (groups.size() == 1 && GROUP_STANDARDS_BY_GROUP != null) {
            String group = (String)groups.iterator().next();
            StandardTask.fillPossStandards((HashMap)GROUP_STANDARDS_BY_GROUP.get(group), maleCount, femaleCount, unsetCount, tm, commonGroup);
        }
        if (!groups.contains("service")) {
            StandardTask.fillPossStandards((HashMap)GROUP_STANDARDS_BY_GROUP.get("service"), maleCount, femaleCount, unsetCount, tm, commonGroup);
        }
        int[] ids = new int[tm.size() + 1];
        String[] dispVals = new String[tm.size() + 1];
        int pos = 0;
        ids[pos] = -1;
        dispVals[pos] = " " + Babel.get("TASK_STD_OTHER") + " ";
        ++pos;
        Iterator iter = tm.values().iterator();
        while (iter.hasNext()) {
            StandardTask st = (StandardTask)iter.next();
            ids[pos] = st.ivID;
            dispVals[pos] = " " + st.getDescription(true) + " ";
            ++pos;
        }
        Object[] res = new Object[]{ids, dispVals};
        return res;
    }

    private static void fillPossStandards(HashMap standards, int maleCount, int femaleCount, int unsetCount, TreeMap target, String commonGroup) {
        if (standards != null) {
            Iterator iter = standards.keySet().iterator();
            while (iter.hasNext()) {
                Integer key = (Integer)iter.next();
                StandardTask st = (StandardTask)standards.get(key);
                if (!st.ivVisible) continue;
                if (maleCount != 0 || femaleCount != 0 || unsetCount != 0) {
                    if (!st.allowed(maleCount, femaleCount, unsetCount, commonGroup)) continue;
                    target.put(String.valueOf(st.getDescription(false).toLowerCase()) + "-" + st.ivID, st);
                    continue;
                }
                target.put(String.valueOf(st.getDescription(false).toLowerCase()) + "-" + st.ivID, st);
            }
        }
    }

    public static void checkForToAndFromMating(Vector miceForTransport, Vector miceInMatingToBeSetUp, StringBuffer commandBuffer, int actionDate) {
        if (miceInMatingToBeSetUp != null) {
            Iterator iter = miceInMatingToBeSetUp.iterator();
            while (iter.hasNext()) {
                Mouse mouse = (Mouse)iter.next();
                TaskExtended.addTaskFinishsToComBuff(mouse, mouse.getTaskKey(), TASK_AC_TO_MATING, 0L, commandBuffer, actionDate);
                TaskExtended.addTaskFinishsToComBuff(mouse, mouse.getTaskKey(), TASK_AC_RUDELBUMS, 0L, commandBuffer, actionDate);
            }
        }
        if (miceForTransport != null) {
            HashMap<Cage, Vector<Mouse>> transportMiceByCage = new HashMap<Cage, Vector<Mouse>>();
            Iterator iter = miceForTransport.iterator();
            while (iter.hasNext()) {
                Mouse mouse = (Mouse)iter.next();
                Cage cage = mouse.getActCage();
                if (cage == null || !cage.isMatingCage()) continue;
                Vector<Mouse> v = (Vector<Mouse>)transportMiceByCage.get(cage);
                if (v == null) {
                    v = new Vector<Mouse>();
                    transportMiceByCage.put(cage, v);
                }
                v.add(mouse);
            }
            if (!transportMiceByCage.isEmpty()) {
                Vector matureMiceVor = new Vector();
                Vector matureMiceZwisch = new Vector();
                Vector matureMiceNach = new Vector();
                Iterator iterator = transportMiceByCage.keySet().iterator();
                while (iterator.hasNext()) {
                    Cage cage = (Cage)iterator.next();
                    Vector transportMice = (Vector)transportMiceByCage.get(cage);
                    matureMiceVor.clear();
                    matureMiceZwisch.clear();
                    matureMiceNach.clear();
                    int matRes = CageManager.isAMating(cage.getActualMice(), false, matureMiceVor);
                    if (matRes == 0) continue;
                    matureMiceZwisch.addAll(matureMiceVor);
                    Iterator iterator2 = transportMice.iterator();
                    while (iterator2.hasNext()) {
                        Mouse mouse = (Mouse)iterator2.next();
                        matureMiceZwisch.remove(mouse);
                    }
                    matRes = CageManager.isAMating(matureMiceZwisch, false, matureMiceNach);
                    Vector miceToHandle = null;
                    miceToHandle = matRes == 0 ? matureMiceVor : transportMice;
                    Iterator iterator22 = miceToHandle.iterator();
                    while (iterator22.hasNext()) {
                        Mouse mouse = (Mouse)iterator22.next();
                        TaskExtended.addTaskFinishsToComBuff(mouse, mouse.getTaskKey(), TASK_AC_MATING_END, 0L, commandBuffer, actionDate);
                    }
                }
            }
        }
    }

    public static Vector getUnfinishedStandardTasks(IDObject ido, String taskKey, String autoCompletionTag, long additionalObjectID) {
        Vector<TaskExtended> erg = new Vector<TaskExtended>();
        TaskExtended[] tarr = (TaskExtended[])ido.get(taskKey);
        if (tarr != null) {
            int i = 0;
            while (i < tarr.length) {
                StandardTask st;
                if ((tarr[i].isFixedDayTask() || ArrayHelper.contained(autoCompletionTag, AUTO_COMPLETERS_ALSO_IN_PERIOD)) && !tarr[i].isFinished() && (st = StandardTask.findTask(ido.getString("IDO_GROUP", ""), tarr[i].ivProcType)) != null && st.ivAutocompletion.equalsIgnoreCase(autoCompletionTag)) {
                    if (st.ivAdditionalObjectID == -1L) {
                        erg.add(tarr[i]);
                    } else if (st.ivAdditionalObjectID == additionalObjectID) {
                        erg.add(tarr[i]);
                    }
                }
                ++i;
            }
        }
        if (!erg.isEmpty()) {
            TaskExtended oldestTask = null;
            int oldest = Integer.MAX_VALUE;
            Iterator iter = erg.iterator();
            while (iter.hasNext()) {
                TaskExtended task = (TaskExtended)iter.next();
                if (task.ivDatum >= oldest) continue;
                oldest = task.ivDatum;
                oldestTask = task;
            }
            erg.clear();
            if (oldestTask != null) {
                erg.add(oldestTask);
            }
        }
        return erg;
    }

    public static String getDescription(String group, int standardID, String defVal, boolean mitMark, Object taskExtraObject) {
        StandardTask st = StandardTask.findTask(group, standardID);
        if (st != null) {
            return String.valueOf(mitMark ? st.getMark("") : "") + st.getComboVal() + st.getExtraVal(taskExtraObject, "");
        }
        return defVal;
    }

    public String getDescription(boolean mitMark) {
        return String.valueOf(mitMark ? this.getMark("") : "") + this.getComboVal();
    }

    public static String getMDPrefix(int standardID) {
        if (standardID > 0) {
            if (standardID < 1001) {
                return SYSTEM_MARK;
            }
            if (standardID >= 5001) {
                return SERVICE_MARK;
            }
            return GROUP_MARK;
        }
        return "[I] ";
    }

    public String getIdentifierString() {
        StringBuilder msb = new StringBuilder(this.getGroup());
        msb.append(TRENNER).append(17).append(TRENNER).append(this.ivID);
        return msb.toString();
    }

    public static StandardTask findTask(String group, int standardID) {
        if (standardID > 0) {
            HashMap hm;
            if (standardID < 1001) {
                return (StandardTask)SYSTEM_STANDARDS_BY_ID.get(new Integer(standardID));
            }
            if (standardID >= 5001) {
                HashMap hm2 = (HashMap)GROUP_STANDARDS_BY_GROUP.get("service");
                if (hm2 != null) {
                    return (StandardTask)hm2.get(new Integer(standardID));
                }
            } else if (group != null && (hm = (HashMap)GROUP_STANDARDS_BY_GROUP.get(group)) != null) {
                return (StandardTask)hm.get(new Integer(standardID));
            }
        }
        return null;
    }

    public static int getAutoCompletionOffsetIfThere(String autoCompletion, int procType, String group, int dayOffset, int defVal) {
        StandardTask st;
        if (procType != -1 && (st = StandardTask.findTask(group, procType)) != null) {
            if (st.isPrimaerTask()) {
                return autoCompletion.equals(st.ivAutocompletion) ? dayOffset : defVal;
            }
            if (st.ivCombiIDs != null) {
                int i = 0;
                while (i < st.ivCombiIDs.length) {
                    int doff = StandardTask.getAutoCompletionOffsetIfThere(autoCompletion, st.ivCombiIDs[i], group, dayOffset, defVal);
                    if (doff != defVal) {
                        return doff;
                    }
                    ++i;
                }
            }
        }
        return defVal;
    }

    private static void insertIntoGroupHM(String group, StandardTask st) {
        HashMap<Integer, StandardTask> hm = (HashMap<Integer, StandardTask>)GROUP_STANDARDS_BY_GROUP.get(group);
        if (hm == null) {
            hm = new HashMap<Integer, StandardTask>(100);
            GROUP_STANDARDS_BY_GROUP.put(group, hm);
        }
        hm.put(new Integer(st.ivID), st);
    }

    public static Vector getAllStandardTasks() {
        Vector erg = new Vector();
        erg.addAll(SYSTEM_STANDARDS_BY_ID.values());
        Iterator iter = GROUP_STANDARDS_BY_GROUP.values().iterator();
        while (iter.hasNext()) {
            HashMap hm = (HashMap)iter.next();
            erg.addAll(hm.values());
        }
        return erg;
    }

    public static Vector getExcelVector(String group) {
        Vector erg = new Vector();
        Vector<String> line = new Vector<String>();
        erg.add(line);
        int i = 0;
        while (i < EXCEL_HEADERS.length) {
            line.add(EXCEL_HEADERS[i]);
            ++i;
        }
        String content = FileManager.getStringFromFile(GroupFileManager.getStandardTaskPath(group));
        if (content != null) {
            Vector lines = StringHelper.splitStringByAny(content, "\n");
            Iterator iter = lines.iterator();
            while (iter.hasNext()) {
                String sline = (String)iter.next();
                if ((sline = sline.trim()).length() == 0 || sline.startsWith("#")) continue;
                Zeile z = new Zeile(sline, '|');
                line = new Vector();
                erg.add(line);
                int i2 = 0;
                while (i2 < EXCEL_HEADERS.length) {
                    line.add(z.getString(i2, ""));
                    ++i2;
                }
            }
        }
        return erg;
    }

    public static void readExcelVector(Vector lines, String group) {
        if (lines != null && lines.size() > 1) {
            Vector firstLine = (Vector)lines.elementAt(0);
            StringBuffer msb = new StringBuffer();
            int i = 1;
            while (i < lines.size()) {
                String id = null;
                String descr = null;
                String sexRestr = "";
                String autoCompl = "";
                String visible = "1";
                String combiInfo = "";
                String minimumAge = "-1";
                String maximumAge = "-1";
                Vector line = (Vector)lines.elementAt(i);
                int j = 0;
                while (j < line.size()) {
                    if (j < firstLine.size()) {
                        String header = ((String)firstLine.elementAt(j)).trim();
                        String val = ((String)line.elementAt(j)).trim();
                        if (header.equalsIgnoreCase(HEADER_ID)) {
                            try {
                                int idi = Integer.parseInt(val);
                                if (idi >= 1001) {
                                    id = val;
                                }
                            }
                            catch (Exception exception) {}
                        } else if (header.equalsIgnoreCase(HEADER_DESCR)) {
                            if (val.length() != 0) {
                                descr = val;
                            }
                        } else if (header.equalsIgnoreCase(HEADER_SEX_RESTR)) {
                            sexRestr = val;
                        } else if (header.equalsIgnoreCase(HEADER_AUTO_COMPL)) {
                            autoCompl = val;
                        } else if (header.equalsIgnoreCase(HEADER_VISIBLE)) {
                            if (val.equals("1") || val.equals("0")) {
                                visible = val;
                            }
                        } else if (header.equalsIgnoreCase(HEADER_COMBI_INFO)) {
                            combiInfo = val;
                        } else if (header.equalsIgnoreCase(HEADER_MINIMUM_AGE)) {
                            minimumAge = val;
                        } else if (header.equalsIgnoreCase(HEADER_MAXIMUM_AGE)) {
                            maximumAge = val;
                        }
                    }
                    ++j;
                }
                if (id != null && descr != null) {
                    msb.append(id).append(TRENNER);
                    msb.append("B64@").append(Base64Manager.encodeBase64(descr)).append(TRENNER);
                    msb.append(sexRestr).append(TRENNER);
                    msb.append(autoCompl).append(TRENNER);
                    msb.append(visible).append(TRENNER);
                    msb.append(combiInfo).append(TRENNER);
                    msb.append(minimumAge).append(TRENNER);
                    msb.append(maximumAge).append(TRENNER);
                    msb.append("\n");
                }
                ++i;
            }
            FileManager.saveStringToFile(GroupFileManager.getStandardTaskPath(group), msb.toString());
        }
    }

    private StandardTask(String defLine, String group) {
        Zeile z3;
        Zeile z = new Zeile(defLine, '|');
        this.ivID = z.getInt(0, 0);
        this.ivDescrBabel = z.getStringNONEmptyEvtlB64(1, "").trim();
        String restriction = z.getString(2, "").trim();
        Zeile z2 = new Zeile(restriction, '@');
        this.ivSexRestriction = z2.getString(0, TASK_SEX_ANY);
        String dateRestr = TASK_DATE_ANY;
        boolean singleGroup = false;
        if (z2.size() > 1) {
            int i = 1;
            while (i < z2.size()) {
                String s = z2.getStringNONEmpty(i, null);
                if (s != null) {
                    if (ArrayHelper.findStringInArray(s, DATE_RESTRICTIONS) != -1) {
                        dateRestr = s;
                    } else if (s.equals(TASK_SINGLE_GROUP)) {
                        singleGroup = true;
                    }
                }
                ++i;
            }
        }
        this.ivDateRestriction = dateRestr;
        this.ivSingleGroupOnly = singleGroup;
        String autoComplet = z.getString(3, "").trim();
        int ind = autoComplet.indexOf(TRENNER2);
        if (ind == -1) {
            this.ivAutocompletion = autoComplet;
            this.ivAdditionalObjectID = -1L;
        } else {
            this.ivAutocompletion = autoComplet.substring(0, ind);
            try {
                this.ivAdditionalObjectID = Long.parseLong(autoComplet.substring(ind + 1, autoComplet.length()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.ivVisible = z.getString(4, "").trim().equals("1");
        this.ivChangeable = this.ivID >= 1001;
        String s = z.getString(5, "").trim();
        if (s == null || s.length() == 0) {
            this.ivCombiIDs = null;
            this.ivCombiDayOffsets = null;
            this.ivCombiTimePrefs = null;
        } else {
            z2 = new Zeile(s, ';');
            int anzCombis = z2.size();
            this.ivCombiIDs = new int[anzCombis];
            this.ivCombiDayOffsets = new int[anzCombis];
            this.ivCombiTimePrefs = new int[anzCombis];
            int ds = 0;
            while (ds < anzCombis) {
                Zeile z32 = new Zeile(z2.getString(ds, ""), ',');
                if (z32.size() == 3) {
                    this.ivCombiIDs[ds] = z32.getInt(0, 0);
                    this.ivCombiDayOffsets[ds] = z32.getInt(1, 0);
                    this.ivCombiTimePrefs[ds] = z32.getInt(2, 0);
                }
                ++ds;
            }
        }
        s = z.getString(6, "").trim();
        if (s != null && s.length() != 0 && (z3 = new Zeile(s, ',')).size() == 3) {
            this.ivTriangleColor = new Color(z3.getInt(0, 0), z3.getInt(1, 0), z3.getInt(2, 0));
        }
        this.ivWorkFlowDef = z.getStringNONEmpty(7, null);
        this.ivMinimumAge = z.getInt(8, -1);
        this.ivMaximumAge = z.getInt(9, -1);
        if (this.ivID < 1001) {
            SYSTEM_STANDARDS_BY_ID.put(new Integer(this.ivID), this);
        } else if (this.ivID >= 5001) {
            StandardTask.insertIntoGroupHM("service", this);
        } else {
            StandardTask.insertIntoGroupHM(group, this);
        }
        this.set("IDO_GROUP", group);
        this.setBoolean("IDO_VISIBLE", this.ivVisible);
        this.setLong("IDO_ID", MilliSpender.getMillis());
        this.commit(false);
    }

    public StandardTask(String descr, String sexRestriction, String dateRestriction, String autoCompletion, Color triangleColor, String group, int[] combiIDs, int[] combiDayOffsets, int[] combiTimePrefs, long additionalObjectID, boolean singleGroupOnly, int minimumAge, int maximumAge) {
        this.ivDescrBabel = descr;
        this.ivSexRestriction = sexRestriction;
        this.ivDateRestriction = dateRestriction;
        this.ivAutocompletion = autoCompletion;
        this.ivTriangleColor = triangleColor;
        this.ivAdditionalObjectID = additionalObjectID;
        this.ivVisible = true;
        this.ivChangeable = true;
        this.ivCombiIDs = combiIDs;
        this.ivCombiDayOffsets = combiDayOffsets;
        this.ivCombiTimePrefs = combiTimePrefs;
        this.ivSingleGroupOnly = singleGroupOnly;
        this.ivMinimumAge = minimumAge;
        this.ivMaximumAge = maximumAge;
        HashMap<Integer, StandardTask> hm = (HashMap<Integer, StandardTask>)GROUP_STANDARDS_BY_GROUP.get(group);
        if (hm == null) {
            hm = new HashMap<Integer, StandardTask>(100);
            GROUP_STANDARDS_BY_GROUP.put(group, hm);
        }
        int id = MausoleumClient.isHeadOfService() ? 5001 : 1001;
        while (hm.get(new Integer(id)) != null) {
            ++id;
        }
        this.ivID = id;
        hm.put(new Integer(this.ivID), this);
        this.set("IDO_GROUP", group);
        this.setBoolean("IDO_VISIBLE", this.ivVisible);
        this.setLong("IDO_ID", MilliSpender.getMillis());
        this.commit(false);
    }

    public StandardTask(int id, String descr, String sexRestriction, String dateRestriction, String autoCompletion, Color triangleColor, boolean visible, String group, int[] combiIDs, int[] combiDayOffsets, int[] combiTimePrefs, long additionalObjectID, boolean singleGroupOnly, int minimumAge, int maximumAge) {
        this.ivID = id;
        this.ivDescrBabel = descr;
        this.ivSexRestriction = sexRestriction;
        this.ivDateRestriction = dateRestriction;
        this.ivAutocompletion = autoCompletion;
        this.ivTriangleColor = triangleColor;
        this.ivAdditionalObjectID = additionalObjectID;
        this.ivVisible = visible;
        this.ivChangeable = true;
        this.ivCombiIDs = combiIDs;
        this.ivCombiDayOffsets = combiDayOffsets;
        this.ivCombiTimePrefs = combiTimePrefs;
        this.ivSingleGroupOnly = singleGroupOnly;
        this.ivMinimumAge = minimumAge;
        this.ivMaximumAge = maximumAge;
        StandardTask.insertIntoGroupHM(group, this);
        this.set("IDO_GROUP", group);
        this.setBoolean("IDO_VISIBLE", this.ivVisible);
        this.setLong("IDO_ID", MilliSpender.getMillis());
        this.commit(false);
    }

    public String getName(String nullVal) {
        return nullVal;
    }

    private void appendConfigLine(StringBuilder msb) {
        if (this.isSystemTask() && this.ivVisible) {
            return;
        }
        msb.append(this.ivID).append(TRENNER);
        msb.append("B64@").append(Base64Manager.encodeBase64(this.ivDescrBabel)).append(TRENNER);
        msb.append(this.ivSexRestriction).append(TRENNER2).append(this.ivDateRestriction).append(TRENNER2).append(this.ivSingleGroupOnly ? TASK_SINGLE_GROUP : "").append(TRENNER);
        if (this.ivAdditionalObjectID == -1L) {
            msb.append(this.ivAutocompletion).append(TRENNER);
        } else {
            msb.append(this.ivAutocompletion).append(TRENNER2).append(this.ivAdditionalObjectID).append(TRENNER);
        }
        if (this.ivVisible) {
            msb.append("1").append(TRENNER);
        } else {
            msb.append("0").append(TRENNER);
        }
        this.appendCombiInfo(msb);
        msb.append(TRENNER);
        if (this.ivTriangleColor != null) {
            msb.append(this.ivTriangleColor.getRed()).append(",");
            msb.append(this.ivTriangleColor.getGreen()).append(",");
            msb.append(this.ivTriangleColor.getBlue());
        }
        msb.append(TRENNER);
        if (this.ivWorkFlowDef != null) {
            msb.append(this.ivWorkFlowDef);
        }
        msb.append(TRENNER);
        msb.append(this.ivMinimumAge).append(TRENNER);
        msb.append(this.ivMaximumAge).append(TRENNER);
        msb.append("\n");
    }

    private boolean allowed(int maleCount, int femaleCount, int unsetCount, String commonGroup) {
        if (this.ivSingleGroupOnly && commonGroup == null) {
            return false;
        }
        if (this.ivSexRestriction.equalsIgnoreCase(TASK_SEX_MALE)) {
            return unsetCount == 0 && femaleCount == 0;
        }
        if (this.ivSexRestriction.equalsIgnoreCase(TASK_SEX_FEMALE)) {
            return unsetCount == 0 && maleCount == 0;
        }
        if (this.ivSexRestriction.equalsIgnoreCase(TASK_SEX_UNSET)) {
            return maleCount == 0 && femaleCount == 0;
        }
        if (this.ivSexRestriction.equalsIgnoreCase(TASK_SEX_ANY)) {
            return true;
        }
        return this.ivSexRestriction.equalsIgnoreCase(TASK_SEX_MATING) && unsetCount == 0 && maleCount != 0 && femaleCount != 0 && maleCount <= femaleCount;
    }

    public String getDefTypeBabel(String defVal) {
        if (this.isSystemTask()) {
            return Babel.get("STDT_SYSTEM");
        }
        if (this.isInstituteTask()) {
            return Babel.get("STDT_INSTITUTE");
        }
        if (this.isGroupTask()) {
            return Babel.get("STDT_GROUP");
        }
        return defVal;
    }

    public String getMark(String defVal) {
        if (this.isSystemTask()) {
            return SYSTEM_MARK;
        }
        if (this.isInstituteTask()) {
            return SERVICE_MARK;
        }
        if (this.isGroupTask()) {
            return GROUP_MARK;
        }
        return defVal;
    }

    public boolean isSystemTask() {
        return StandardTask.isSystemTask(this.ivID);
    }

    public boolean isInstituteTask() {
        return StandardTask.isInstituteTask(this.ivID);
    }

    public boolean isGroupTask() {
        return StandardTask.isGroupTask(this.ivID);
    }

    public String getDateRestriction() {
        if (TASK_DATE_FIX.equalsIgnoreCase(this.ivDateRestriction)) {
            return TASK_DATE_FIX;
        }
        if (TASK_DATE_PERIOD.equalsIgnoreCase(this.ivDateRestriction)) {
            return TASK_DATE_PERIOD;
        }
        return TASK_DATE_ANY;
    }

    public String getComboVal() {
        if (this.ivID < 1001 && this.ivID < 5001) {
            return Babel.get(this.ivDescrBabel);
        }
        return this.ivDescrBabel;
    }

    public String getExtraVal(Object extraVal, String defVal) {
        if (extraVal != null && this.ivID == 9) {
            return " " + Babel.get("WITH_SUBSEQUENT_WORKFLOW");
        }
        return defVal;
    }

    public boolean isPrimaerTask() {
        return this.ivCombiIDs == null;
    }

    public boolean isCombiTask() {
        return this.ivCombiIDs != null;
    }

    public void appendCombiInfo(StringBuilder msb) {
        if (this.ivCombiIDs != null) {
            int i = 0;
            while (i < this.ivCombiIDs.length) {
                if (i != 0) {
                    msb.append(";");
                }
                msb.append(this.ivCombiIDs[i]).append(",");
                msb.append(this.ivCombiDayOffsets[i]).append(",");
                msb.append(this.ivCombiTimePrefs[i]);
                ++i;
            }
        }
    }
}

