/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;

public abstract class DemoMaler {
    private static final String DEMO_TEXT = "DEMO";
    private static final Font DEMO_FONT = new Font("Serif", 1, 60);
    private static final FontRenderContext DEMO_FRC = new FontRenderContext(null, false, false);
    private static final TextLayout DEMO_TEXT_LAYOUT = new TextLayout("DEMO", DEMO_FONT, DEMO_FRC);
    private static final float DEMO_H_HALB = (float)(DEMO_TEXT_LAYOUT.getBounds().getHeight() / 2.0);
    private static int cvDemoSW = -1;

    public static void maleDemo(Graphics2D g2d, Dimension d) {
        double winkel = Math.atan((double)d.height / (double)d.width);
        if (cvDemoSW == -1) {
            cvDemoSW = g2d.getFontMetrics(DEMO_FONT).stringWidth(DEMO_TEXT);
        }
        double l = Math.sqrt(d.height * d.height + d.width * d.width);
        double a = (l - (double)cvDemoSW) / 2.0;
        double x2 = a * Math.cos(winkel);
        double y2 = a * Math.sin(winkel);
        g2d.translate(x2, (double)d.height - y2);
        g2d.rotate(-winkel);
        AffineTransform textAt = new AffineTransform();
        textAt.translate(0.0, DEMO_H_HALB);
        Shape outline = DEMO_TEXT_LAYOUT.getOutline(textAt);
        Object hint = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(Color.lightGray);
        g2d.fill(outline);
        g2d.setColor(Color.gray);
        BasicStroke wideStroke = new BasicStroke(2.0f);
        g2d.setStroke(wideStroke);
        g2d.draw(outline);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, hint);
        g2d.rotate(winkel);
        g2d.translate(-x2, -((double)d.height - y2));
    }
}

