/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollBarUI;
import mausoleum.gui.ColorManager;
import mausoleum.gui.ScrollBarButton;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.main.DefaultManager;

public class MausoleumScrollBarUI
extends MetalScrollBarUI {
    private static final int WATCH_MARGIN = ScrollBarButton.SIZE + 2;
    private Image ivTrack = null;
    private Image ivThumbNorm = null;
    private int ivTrackWidth = -1;
    private int ivTrackHeight = -1;
    private int ivThumbWidth = -1;
    private int ivThumbHeight = -1;
    private final double ivAngle = Math.random() * 88.0 + 1.0;
    private final double ivPercent = Math.random();

    public static ComponentUI createUI(JComponent c) {
        return new MausoleumScrollBarUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.setPreferredSize(new Dimension(ScrollBarButton.SIZE, ScrollBarButton.SIZE));
    }

    protected JButton createDecreaseButton(int orientation) {
        if (this.scrollbar.getOrientation() == 1) {
            return new ScrollBarButton(3);
        }
        return new ScrollBarButton(2);
    }

    protected JButton createIncreaseButton(int orientation) {
        if (this.scrollbar.getOrientation() == 1) {
            return new ScrollBarButton(4);
        }
        return new ScrollBarButton(1);
    }

    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        boolean newt = false;
        if (this.ivTrack == null) {
            newt = true;
        } else if (trackBounds.width != this.ivTrackWidth || trackBounds.height != this.ivTrackHeight) {
            newt = true;
        }
        if (newt) {
            this.createTrack(trackBounds);
        }
        if (this.ivTrack != null) {
            g.drawImage(this.ivTrack, trackBounds.x, trackBounds.y, null);
        }
    }

    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (c.isEnabled()) {
            Rectangle r = null;
            if (this.scrollbar.getOrientation() == 1) {
                r = new Rectangle(thumbBounds.x + 2, thumbBounds.y, thumbBounds.width - 4, thumbBounds.height - 1);
                if (r.y < WATCH_MARGIN) {
                    r.y = WATCH_MARGIN;
                } else if (r.y + r.height > this.scrollbar.getSize().height - WATCH_MARGIN) {
                    r.height = this.scrollbar.getSize().height - WATCH_MARGIN - r.y;
                }
            } else {
                r = new Rectangle(thumbBounds.x, thumbBounds.y + 2, thumbBounds.width - 1, thumbBounds.height - 4);
                if (r.x < WATCH_MARGIN) {
                    r.x = WATCH_MARGIN;
                } else if (r.x + r.width > this.scrollbar.getSize().width - WATCH_MARGIN) {
                    r.width = this.scrollbar.getSize().width - WATCH_MARGIN - r.x;
                }
            }
            if (r.width > 0 && r.height > 0) {
                boolean newt = false;
                if (this.ivThumbNorm == null) {
                    newt = true;
                } else if (r.width != this.ivThumbWidth || r.height != this.ivThumbHeight) {
                    newt = true;
                }
                if (newt) {
                    this.createThumbs(r);
                }
                if (this.ivThumbNorm != null) {
                    g.drawImage(this.ivThumbNorm, r.x, r.y, null);
                }
            }
        }
    }

    private void createTrack(Rectangle r) {
        if (r.width > 0 && r.height > 0) {
            this.ivTrack = new BufferedImage(r.width, r.height, 1);
            Graphics g = this.ivTrack.getGraphics();
            while (g == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                g = this.ivTrack.getGraphics();
            }
            this.ivTrackWidth = r.width;
            this.ivTrackHeight = r.height;
            if (DefaultManager.getDesign().equals("PLAIN")) {
                Color c = ColorManager.getMausoColor("inspectorBack");
                if (c != null) {
                    g.setColor(c);
                    g.fillRect(0, 0, r.width, r.height);
                }
            } else {
                MausoleumImageStore.drawImage(g, "inspectorBack", r, this.ivAngle, this.ivPercent);
            }
            g.setColor(Color.white);
            g.drawLine(0, 0, r.width, 0);
            g.drawLine(0, 0, 0, r.height);
            g.drawLine(1, r.height - 2, r.width - 2, r.height - 2);
            g.drawLine(r.width - 2, 1, r.width - 2, r.height - 2);
            g.setColor(Color.black);
            g.drawLine(1, 1, r.width - 2, 1);
            g.drawLine(1, 1, 1, r.height - 2);
            g.drawLine(1, r.height - 1, r.width - 1, r.height - 1);
            g.drawLine(r.width - 1, 1, r.width - 1, r.height - 1);
        }
    }

    private void createThumbs(Rectangle r) {
        if (r.width > 0 && r.height > 0) {
            this.ivThumbWidth = r.width;
            this.ivThumbHeight = r.height;
            this.ivThumbNorm = this.scrollbar.createImage(r.width, r.height);
            Graphics g = this.ivThumbNorm.getGraphics();
            MausoleumImageStore.drawImage(g, "blueButton", r, this.ivAngle, this.ivPercent);
            g.setColor(Color.white);
            g.drawLine(0, 0, r.width, 0);
            g.drawLine(0, 0, 0, r.height);
            g.setColor(Color.black);
            g.drawLine(1, r.height - 1, r.width - 1, r.height - 1);
            g.drawLine(r.width - 1, 1, r.width - 1, r.height - 1);
            int wh = r.width / 2;
            int hh = r.height / 2;
            if (g instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            g.setColor(Color.black);
            g.drawLine(wh - 2, hh - 1, wh - 2, hh + 1);
            g.drawLine(wh - 1, hh - 2, wh + 1, hh - 2);
            g.setColor(Color.white);
            g.drawLine(wh + 2, hh - 1, wh + 2, hh + 1);
            g.drawLine(wh - 1, hh + 2, wh + 1, hh + 2);
        }
    }
}

