/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicViewportUI;
import mausoleum.gui.ColorManager;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.main.DefaultManager;
import mausoleum.ui.DemoMaler;

public class MausoleumViewPortUI
extends BasicViewportUI {
    public static boolean cvDemo = false;
    private final double ivAngle = Math.random() * 88.0 + 1.0;
    private final double ivPercent = Math.random();
    private JComponent ivComponent = null;
    private Image ivBack = null;

    public static ComponentUI createUI(JComponent c) {
        return new MausoleumViewPortUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.ivComponent = c;
    }

    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            this.paintBackground(g);
        }
        this.paint(g, c);
        if (cvDemo) {
            DemoMaler.maleDemo((Graphics2D)g, c.getSize());
        }
    }

    protected void paintBackground(Graphics g) {
        Rectangle r = this.ivComponent.getBounds();
        if (DefaultManager.getDesign().equals("PLAIN")) {
            Color c = ColorManager.getMausoColor("inspectorBack");
            if (c != null) {
                g.setColor(c);
                g.fillRect(0, 0, r.width, r.height);
            }
        } else {
            if (this.ivBack == null || r.width != this.ivBack.getWidth(null) || r.height != this.ivBack.getHeight(null)) {
                this.ivBack = MausoleumImageStore.createBack(r, "inspectorBack", this.ivAngle, this.ivPercent);
            }
            if (this.ivBack != null) {
                g.drawImage(this.ivBack, 0, 0, null);
            }
        }
    }
}

