/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.ui;

import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import mausoleum.gui.ColorManager;
import mausoleum.helper.FontManager;
import mausoleum.helper.HTMLEncoder;
import mausoleum.main.ProcessDefinition;

public abstract class UIDef {
    private static final double FACTORY_SCALE_FACTOR = ProcessDefinition.isClient() ? UIDef.calcScaleFactor() : 1.0;
    private static double USER_FACTOR = 1.0;
    private static int DEFAULT_FONT_SIZE = UIDef.getScaled(12);
    public static int RAND = DEFAULT_FONT_SIZE / 2;
    public static int INNER_RAND = DEFAULT_FONT_SIZE / 4;
    public static int LINE_HEIGHT = DEFAULT_FONT_SIZE * 5 / 3;
    public static int FIELD_HEIGHT = DEFAULT_FONT_SIZE * 2;
    public static int BUT_HEIGHT = DEFAULT_FONT_SIZE * 28 / 12;
    public static int BUT_HEIGHT_SMALL = LINE_HEIGHT;
    public static final String TOOLTIP_PRE = "<HTML><body marginwidth=\"5\" marginheight=\"5\">";
    public static final String TOOLTIP_POST = "</body>";
    public static final Color NEW_FOREGROUND = Color.black;
    public static final Color OLD_FOREGROUND = Color.darkGray;
    public static final Color NOT_MINE_FOREGROUND = new Color(0, 0, 210);
    public static final Color NEW_BACKGROUND = new Color(255, 160, 120);
    public static final Color OLD_BACKGROUND = new Color(255, 220, 160);
    public static final Color CHANGED_BACKGROUND = new Color(160, 0, 0);
    public static final Color CHANGED_FOREGROUND = new Color(255, 240, 220);
    public static final Color BACKGROUND_LIGHT_SUB = new Color(255, 255, 235);
    public static final Color BACKGROUND_SUB = new Color(255, 255, 220);
    public static final Color BACKGROUND_NORMAL = Color.white;
    public static final Color BACKGROUND_RESTRICTED = new Color(255, 240, 240);
    public static final Color GERADE_ROW_COL = new Color(230, 230, 255);
    public static final Color SELECTED_BACKGROUND = ColorManager.getColorFromString("gold");
    public static final Color DARKER_SELECTED_BACKGROUND = ColorManager.getDarkerColor(SELECTED_BACKGROUND);
    public static final Color LIGHTER_SELECTED_BACKGROUND = ColorManager.getLighterColor(SELECTED_BACKGROUND);
    public static final Color SELECTED_BACKGROUND_TRANSP = new Color(SELECTED_BACKGROUND.getRed(), SELECTED_BACKGROUND.getGreen(), SELECTED_BACKGROUND.getBlue(), 128);
    public static final Color TOOLTIP_BACKGROUND = new Color(250, 248, 220);
    public static final Color OBJECT_DEFAULT_COLOR = Color.white;
    public static final Color ALARM_COLOR = ColorManager.getColorFromString("firebrick");
    public static final Color MAIN_BUTTON_BACK_COLOR = new Color(221, 218, 197);
    public static final Color MAIN_BUTTON_FORE_COLOR = Color.black;
    public static final Color YELLOW_COLOR = new Color(241, 238, 197);
    public static final Color ORANGE_COLOR = new Color(239, 210, 197);
    public static final Color PURPLE_COLOR = new Color(241, 197, 238);
    public static final Color GREEN_COLOR = new Color(197, 244, 197);
    public static final Color DARK_GREEN_COLOR = ColorManager.getDarkerColor(GREEN_COLOR);
    public static final Color PINK_COLOR = new Color(244, 197, 197);
    public static final Color BLUE_COLOR = new Color(197, 197, 244);
    public static final Color GRAY_COLOR = new Color(230, 230, 230);
    public static final String STR_HAKEN = "\u2713";
    public static final Dimension MINI_DIM = new Dimension(10, 10);

    public static TitledBorder getTitleBorder(String titelBabel) {
        return new TitledBorder(new EtchedBorder(), " " + Babel.get(titelBabel) + " ", 0, 0, FontManager.getFont("SSI11"), Color.black);
    }

    public static String getToolTipString(String contSepByNLAndTAB) {
        StringBuilder msb = new StringBuilder("<HTML><body text=\"#000000\">");
        msb.append("<table>\n");
        Vector lines = StringHelper.splitStringByAny(contSepByNLAndTAB, "\n");
        int i = 0;
        while (i < lines.size()) {
            String line = (String)lines.elementAt(i);
            if ((line = line.trim()).length() != 0) {
                msb.append("<tr>\n");
                Vector w = StringHelper.splitStringByAny(line, "\t");
                int j = 0;
                while (j < w.size()) {
                    String td = (String)w.elementAt(j);
                    if (j == 0) {
                        msb.append("<td valign=\"top\">&nbsp;").append(HTMLEncoder.convertToHTML(td)).append("&nbsp;</td>\n");
                    } else if (td.length() > 60) {
                        if (td.length() > 500) {
                            td = String.valueOf(td.substring(0, 500)) + "...";
                        }
                        msb.append("<td width=\"200\" valign=\"top\">&nbsp;").append(HTMLEncoder.convertToHTML(td)).append("&nbsp;</td>\n");
                    } else {
                        msb.append("<td valign=\"top\">&nbsp;").append(HTMLEncoder.convertToHTML(td)).append("&nbsp;</td>\n");
                    }
                    ++j;
                }
                msb.append("</tr>\n");
            }
            ++i;
        }
        msb.append("</table>\n");
        msb.append(TOOLTIP_POST);
        return msb.toString();
    }

    private static double calcScaleFactor() {
        double scaleFactor;
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int x = d.height < d.width ? d.height : d.width;
        int bezugsBildschirmGroesse = 1000;
        double faktorSimpel = (double)x / (double)bezugsBildschirmGroesse;
        int spreizFaktor = 900;
        double x2 = (double)(x - bezugsBildschirmGroesse) / (double)spreizFaktor;
        double pow1 = Math.pow(-x2, 3.0);
        double exp2 = 0.3333333333333333;
        double faktorKomplex = Math.pow(1.0 - pow1, exp2);
        faktorKomplex = (faktorKomplex + 3.0 * faktorSimpel) / 4.0;
        double d2 = scaleFactor = faktorKomplex > 1.0 && faktorKomplex > faktorSimpel ? faktorSimpel : faktorKomplex;
        if (scaleFactor < 1.0) {
            scaleFactor = 1.0;
        }
        return scaleFactor;
    }

    public static int getScaled(int size12) {
        return ProcessDefinition.isClient() ? (int)((double)size12 * UIDef.getScaleFactor() + 0.5) : size12;
    }

    public static Rectangle getScaledRect(int x, int y, int w, int h) {
        return new Rectangle(UIDef.getScaled(x), UIDef.getScaled(y), UIDef.getScaled(w), UIDef.getScaled(h));
    }

    public static Dimension getScaledDim(int w, int h) {
        return new Dimension(UIDef.getScaled(w), UIDef.getScaled(h));
    }

    public static double getUserFactor() {
        return USER_FACTOR;
    }

    public static double getScaleFactor() {
        return FACTORY_SCALE_FACTOR * USER_FACTOR;
    }

    public static boolean setUserfactor(double userFactor) {
        if (USER_FACTOR != userFactor) {
            USER_FACTOR = userFactor;
            DEFAULT_FONT_SIZE = UIDef.getScaled(12);
            RAND = DEFAULT_FONT_SIZE / 2;
            INNER_RAND = DEFAULT_FONT_SIZE / 4;
            LINE_HEIGHT = DEFAULT_FONT_SIZE * 5 / 3;
            FIELD_HEIGHT = DEFAULT_FONT_SIZE * 2;
            BUT_HEIGHT = DEFAULT_FONT_SIZE * 28 / 12;
            BUT_HEIGHT_SMALL = LINE_HEIGHT;
            return true;
        }
        return false;
    }

    public static EmptyBorder getScaledEmptyBorder(int top, int left, int bottom, int right) {
        return new EmptyBorder(UIDef.getScaled(top), UIDef.getScaled(left), UIDef.getScaled(bottom), UIDef.getScaled(right));
    }

    public static JLabel highlightLabelIf(JLabel label, boolean highlight, boolean mitHintegrund) {
        return UIDef.highlightLabelIf(label, highlight, mitHintegrund, FontManager.getFont("SSP11"), FontManager.getFont("SSB11"), Color.lightGray, Color.black, null, ColorManager.getColorFromString("mistyrose"));
    }

    public static JLabel highlightLabelIf(JLabel label, boolean highlight, boolean mitHintegrund, Font normalFont, Font highlightFont, Color normalForeground, Color highlightForeground, Color normalBackground, Color highlightBackground) {
        if (highlight) {
            if (mitHintegrund) {
                label.setOpaque(highlightBackground != null);
                label.setBackground(highlightBackground);
            }
            label.setFont(highlightFont);
            label.setForeground(highlightForeground);
        } else {
            if (mitHintegrund) {
                label.setOpaque(normalBackground != null);
                label.setBackground(normalBackground);
            }
            label.setFont(normalFont);
            label.setForeground(normalForeground);
        }
        return label;
    }

    public static void distributeButtons(JComponent[] comps, int x, int y, int h, int totWidth) {
        int lbw = UIDef.getNormButW(totWidth, comps.length);
        int i = 0;
        while (i < comps.length) {
            if (i != comps.length - 1) {
                comps[i].setBounds(x, y, lbw, h);
                x += lbw + INNER_RAND;
            } else {
                comps[i].setBounds(x, y, UIDef.getLastButW(totWidth, lbw, comps.length), h);
            }
            ++i;
        }
    }

    public static void distributeButtonsCheckPrefWidth(JComponent[] comps, int x, int y, int h, int totWidth) {
        int anzButs = comps.length;
        int lbw = UIDef.getNormButW(totWidth, anzButs);
        boolean extraNecess = false;
        int i = 0;
        while (i < comps.length) {
            if (comps[i].getPreferredSize().width > lbw) {
                extraNecess = true;
            }
            ++i;
        }
        if (extraNecess) {
            int vertBreite = totWidth - (anzButs - 1) * INNER_RAND;
            int sumBut = 0;
            int i2 = 0;
            while (i2 < comps.length) {
                sumBut += comps[i2].getPreferredSize().width;
                ++i2;
            }
            if (sumBut < vertBreite) {
                int rest = vertBreite - sumBut;
                int jeder = rest / anzButs;
                rest -= anzButs * jeder;
                int i3 = 0;
                while (i3 < comps.length) {
                    int ww = comps[i3].getPreferredSize().width + jeder;
                    if (rest != 0) {
                        ++ww;
                        --rest;
                    }
                    comps[i3].setBounds(x, y, ww, h);
                    x += ww + INNER_RAND;
                    ++i3;
                }
                return;
            }
        }
        i = 0;
        while (i < comps.length) {
            if (i != comps.length - 1) {
                comps[i].setBounds(x, y, lbw, h);
                x += lbw + INNER_RAND;
            } else {
                comps[i].setBounds(x, y, UIDef.getLastButW(totWidth, lbw, comps.length), h);
            }
            ++i;
        }
    }

    public static void distributeButtons(Vector comps, int x, int y, int h, int totWidth) {
        int lbw = UIDef.getNormButW(totWidth, comps.size());
        int i = 0;
        while (i < comps.size()) {
            if (i != comps.size() - 1) {
                ((JComponent)comps.elementAt(i)).setBounds(x, y, lbw, h);
                x += lbw + INNER_RAND;
            } else {
                ((JComponent)comps.elementAt(i)).setBounds(x, y, UIDef.getLastButW(totWidth, lbw, comps.size()), h);
            }
            ++i;
        }
    }

    public static Point getNormAndLastBW(int totW, int anzButs) {
        int lbw = UIDef.getNormButW(totW, anzButs);
        return new Point(lbw, UIDef.getLastButW(totW, lbw, anzButs));
    }

    public static int getNormButW(int totW, int anzButs) {
        return (totW - (anzButs - 1) * INNER_RAND) / anzButs;
    }

    public static int getLastButW(int totW, int lbw, int anzButs) {
        return totW - (anzButs - 1) * (lbw + INNER_RAND);
    }
}

