/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.util;

import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JFrame;
import mausoleum.alert.Alert;
import mausoleum.helper.Zeile;
import mausoleum.main.ProcessDefinition;
import mausoleum.requester.TextRequester;

public class GeneralSetting
implements Comparable {
    public static final boolean EXETND_LITTER_REPORT_EXTRA = false;
    public static final boolean WITH_WORKFLOW = false;
    public static final boolean WITH_RACKHEALTH = true;
    public static final boolean WITH_REPORT_EXTRA_MATING_LINE = false;
    public static final boolean TEST_MODE = false;
    public static final int LIMIT_MOUSE_LITTER = 50;
    public static final int LIMIT_FISH_LITTER = 250;
    public static final int LIMIT_MOUSE_NEW = 100;
    public static final int LIMIT_FISH_NEW = 300;
    public final String ivName;
    public final String ivPayload;

    public static Vector getSettings(HashMap settingsMap, String key, String path) {
        if (ProcessDefinition.isClient()) {
            Vector res;
            if (settingsMap.isEmpty()) {
                GeneralSetting.getContent(settingsMap, path);
            }
            if ((res = (Vector)settingsMap.get(key)) == null) {
                res = new Vector();
                settingsMap.put(key, res);
            }
            return res;
        }
        return null;
    }

    public static boolean deleteSetting(GeneralSetting toRemove, HashMap settingsMap, String key, String path) {
        Vector settings;
        boolean res;
        if (ProcessDefinition.isClient() && (res = Alert.showAlert(Babel.get("FST_SURETODELETE_DEFINITION"), false)) && (settings = GeneralSetting.getSettings(settingsMap, key, path)) != null) {
            boolean takeit = false;
            if (settings.contains(toRemove)) {
                takeit = true;
                settings.remove(toRemove);
            }
            if (takeit) {
                GeneralSetting.saveContent(settingsMap, path);
                return true;
            }
        }
        return false;
    }

    public static boolean saveAktSetting(JFrame parent, String payloadContent, HashMap settingsMap, String key, String path) {
        String newName;
        if (ProcessDefinition.isClient() && (newName = TextRequester.displayTextRequester(parent, Babel.get("ENTER_NAME"))) != null && (newName = newName.trim()).length() != 0) {
            boolean takeit = true;
            Vector<GeneralSetting> settings = GeneralSetting.getSettings(settingsMap, key, path);
            if (settings != null) {
                Vector<GeneralSetting> toRemove = new Vector<GeneralSetting>();
                Iterator iterator = settings.iterator();
                while (iterator.hasNext()) {
                    GeneralSetting sts = (GeneralSetting)iterator.next();
                    if (!sts.ivName.equalsIgnoreCase(newName)) continue;
                    takeit = Alert.showAlert(Babel.get("DEFINITION_NAME_IN_USE"), false);
                    toRemove.add(sts);
                }
                if (!toRemove.isEmpty()) {
                    iterator = toRemove.iterator();
                    while (iterator.hasNext()) {
                        settings.remove(iterator.next());
                    }
                }
            }
            if (takeit) {
                if (settings == null) {
                    settings = new Vector<GeneralSetting>();
                }
                settings.add(new GeneralSetting(newName, payloadContent));
                Collections.sort(settings);
                GeneralSetting.saveContent(settingsMap, path);
                return true;
            }
        }
        return false;
    }

    private static void getContent(HashMap settingsMap, String path) {
        settingsMap.clear();
        String s = FileManager.getStringContentFromServer(path);
        if (s != null) {
            Vector defLines = StringHelper.splitStringByAny(s, "\n");
            Iterator iter = defLines.iterator();
            while (iter.hasNext()) {
                int ind;
                String defLine = (String)iter.next();
                if ((defLine = defLine.trim()).length() == 0 || (ind = defLine.indexOf("|")) == -1) continue;
                String key = defLine.substring(0, ind);
                Vector settingLines = StringHelper.splitStringByAny(Base64Manager.getDecodedString(defLine.substring(ind + 1, defLine.length())), "\n");
                Vector<GeneralSetting> settings = new Vector<GeneralSetting>();
                Iterator iterator = settingLines.iterator();
                while (iterator.hasNext()) {
                    String setting = (String)iterator.next();
                    if ((setting = setting.trim()).length() == 0) continue;
                    settings.add(new GeneralSetting(setting));
                }
                Collections.sort(settings);
                if (settings.isEmpty()) continue;
                settingsMap.put(key, settings);
            }
        }
    }

    private static void saveContent(HashMap settingsMap, String path) {
        StringBuffer msb = new StringBuffer();
        Iterator iter = settingsMap.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Vector settings = (Vector)settingsMap.get(key);
            if (settings == null || settings.isEmpty()) continue;
            msb.append(key).append("|");
            StringBuffer tsb = new StringBuffer();
            Iterator iterator = settings.iterator();
            while (iterator.hasNext()) {
                GeneralSetting sts = (GeneralSetting)iterator.next();
                tsb.append(sts.getTransportString()).append("\n");
            }
            msb.append(Base64Manager.encodeBase64(tsb.toString())).append("\n");
        }
        FileManager.saveStringContentToServer(GroupFileManager.getMultiDimDefPath(), msb.toString(), null, UserManager.getFirstGroup());
    }

    public GeneralSetting(String name, String payloadContent) {
        this.ivName = name.trim();
        this.ivPayload = payloadContent;
    }

    public GeneralSetting(String transportString) {
        Zeile z = new Zeile(transportString, '|');
        int col = 0;
        this.ivName = Base64Manager.getDecodedString(z.getString(col++, "")).trim();
        this.ivPayload = Base64Manager.getDecodedString(z.getString(col++, "")).trim();
    }

    public String getTransportString() {
        StringBuffer msb = new StringBuffer();
        msb.append(Base64Manager.encodeBase64(this.ivName)).append("|");
        msb.append(Base64Manager.encodeBase64(this.ivPayload)).append("|");
        return msb.toString();
    }

    public String toString() {
        return this.ivName;
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof GeneralSetting) {
            GeneralSetting sts0 = (GeneralSetting)arg0;
            return this.ivName.compareToIgnoreCase(sts0.ivName);
        }
        return 0;
    }
}

