/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.util;

import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.User;
import java.io.File;
import mausoleum.main.ProcessDefinition;

public abstract class PathStore {
    private static final String SEP = "/";
    public static final String DATA_DIR = "data";
    public static final String FILES_DIR = "files";
    public static final String LOCAL_TEMP_DIR = "tmpclientfiles";
    private static final String SERVER_DIR = "files/server";
    public static final String PORT_FILENAME = "data/httpport.txt";
    public static final String FILENAME_DORMANT_THRES = "data/dormthr.txt";
    public static final String FILENAME_MATURITY_VAL = "data/matval.txt";
    public static final String FILENAME_WEANING_VAL = "data/weaning.txt";
    public static final String FILENAME_MIT_MATING_LINE_MAIL = "data/matlinmail.txt";
    public static final String FILENAME_EXP_ADRESS_MANDATORY = "data/expadrmand.txt";
    public static final String FILENAME_INSTITUTE_HOLIDAYS = "data/instHolidays.def";
    public static final String WINDOW_SETTINGS_DIR = "files/windows";
    public static final String LAST_USED_OBJECTS_DIR = "files/mros";
    public static final String SERVER_BUILD_PATH = "data/serverbuild.txt";
    public static final String CLIENT_BUILD_PATH = "data/clientbuild.txt";
    public static final String LOG_DIR = "files/log";
    public static final String SESS_LOG_DIR = "files/log/sesslogs";
    public static final String ARMIS_DIR = "files/armis";
    public static final String ARMIS_REPORTS_DIR = "files/armis/reportsd";
    public static final String CLIENT_FILES_DIR = "files/client";
    public static final String HELLO_MESSAGE_PATH = "files/server/hellomsg.txt";
    public static final String INST_INFO_MESSAGE_PATH = "files/server/infomsg.txt";
    public static final String GROUP_INFO_MESSAGE_NAME = "infomsg.txt";
    private static String cvServerDir = "files/server";

    public static String checkForServerDirFilename(String filePath) {
        if (filePath.startsWith(SERVER_DIR)) {
            return String.valueOf(PathStore.getServerDir()) + filePath.substring(SERVER_DIR.length(), filePath.length());
        }
        return filePath;
    }

    public static void setServerDir(String serverDir) {
        if (ProcessDefinition.isServer() && serverDir != null) {
            File f;
            if (serverDir.startsWith("\"")) {
                serverDir = serverDir.substring(1, serverDir.length()).trim();
            }
            if (serverDir.endsWith("\"")) {
                serverDir = serverDir.substring(0, serverDir.length() - 1).trim();
            }
            if ((f = new File(serverDir = StringHelper.gSub(serverDir, "\\", SEP))).exists() && f.isDirectory()) {
                cvServerDir = serverDir;
            }
        }
    }

    public static String getServerDir() {
        return cvServerDir != null ? cvServerDir : SERVER_DIR;
    }

    public static String getGroupColorsDir() {
        return GroupFileManager.getGroupDir("service");
    }

    public static String getGroupColorsPath() {
        return String.valueOf(PathStore.getGroupColorsDir()) + SEP + "groupcolors.txt";
    }

    public static String getClientFactorPath() {
        FileManager.prepareDirs(CLIENT_FILES_DIR);
        return "files/client/clientfactors.txt";
    }

    public static String getClientTableZoomPath(User user) {
        String dir = "files/client/" + user.getGroup();
        FileManager.prepareDirs(dir);
        return String.valueOf(dir) + SEP + user.getID() + "_tz.txt";
    }
}

