/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.util;

import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.objectstore.actions.OAGetConfigValue;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Frame;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.tierschutz.TierSchutz;
import mausoleum.requester.AllgChoiceRequester;
import mausoleum.sonderreports.SonderReports;
import mausoleum.util.InstallationType;

public abstract class Standards {
    public static final String DEF_DORMANT_VAL = "DORMANT_VAL";
    public static final String DEF_MATURITY_VAL = "MATURITY_VAL";
    public static final String DEF_WEANING_VAL = "WEANING_VAL";
    public static final String DEF_TIERSCHUTZ_VAL = "TIERSCHUTZ";
    public static final String DEF_SONDERREPORTS_VAL = "SONDERREPORTS";
    public static final String DEF_MIT_MATING_LINE_MAIL = "MATING_MIT_LINE_MAIL";
    public static final String DEF_EXPORT_ADDRESS_MANDATORY = "ADDRESS_MANDATORY_EXIT";
    public static final int DORMANT_DEF_MINS = 30;
    public static final int DORMANT_MIN_MINS = 10;
    public static final int DORMANT_MAX_MINS = 120;
    private static long cvDormantThresholdInMillis = (long)Standards.getConfigInt("DORMANT_VAL", 30, 10, 120) * 60000L;
    private static final int[] DORMANT_INT_VALS = new int[]{10, 15, 20, 30, 45, 60, 90, 120};
    private static final String[] DORMANT_STRING_VALS = new String[]{"10", "15", "20", "30", "45", "60", "90", "120"};
    public static int cvMaturityLimitDEFAULT = InstallationType.isMouse() ? 42 : 84;
    public static int cvMaturityMinValue = InstallationType.isMouse() ? 21 : 60;
    public static int cvMaturityMaxValue = InstallationType.isMouse() ? 56 : 180;
    private static int cvMaturityLimitDays = Standards.getConfigInt("MATURITY_VAL", cvMaturityLimitDEFAULT, cvMaturityMinValue, cvMaturityMaxValue);
    private static int[] cvMaturityIntVals = null;
    private static String[] cvMaturityStringVals = null;
    private static final int WEANING_DEFAULT = 21;
    private static final int WEANING_MIN = 10;
    private static final int WEANING_MAX = 30;
    private static int cvWeaningLimitDays = Standards.getConfigInt("WEANING_VAL", 21, 10, 30);
    private static int[] cvWeaningIntVals = null;
    private static String[] cvWeaningStringVals = null;
    private static int cvMitMatingLineMail = Standards.getConfigInt("MATING_MIT_LINE_MAIL", 0, 0, 1);
    private static int cvExportAdressMandatory = Standards.getConfigInt("ADDRESS_MANDATORY_EXIT", 0, 0, 1);
    static /* synthetic */ Class class$0;

    public static void setConfigInt(String valueType, Frame sender, String meldung) {
        try {
            int prevVal = -1;
            int[] intValues = null;
            String[] stringValues = null;
            if (DEF_DORMANT_VAL.equals(valueType)) {
                prevVal = (int)(cvDormantThresholdInMillis / 60000L);
                intValues = DORMANT_INT_VALS;
                stringValues = DORMANT_STRING_VALS;
            } else if (DEF_MATURITY_VAL.equals(valueType)) {
                prevVal = cvMaturityLimitDays;
                if (cvMaturityIntVals == null) {
                    cvMaturityIntVals = Standards.getArray(cvMaturityMinValue, cvMaturityMaxValue);
                    cvMaturityStringVals = Standards.getArray(cvMaturityIntVals);
                }
                intValues = cvMaturityIntVals;
                stringValues = cvMaturityStringVals;
            } else if (DEF_WEANING_VAL.equals(valueType)) {
                prevVal = cvWeaningLimitDays;
                if (cvWeaningIntVals == null) {
                    cvWeaningIntVals = Standards.getArray(10, 30);
                    cvWeaningStringVals = Standards.getArray(cvWeaningIntVals);
                }
                intValues = cvWeaningIntVals;
                stringValues = cvWeaningStringVals;
            } else if (DEF_MIT_MATING_LINE_MAIL.equals(valueType)) {
                prevVal = cvMitMatingLineMail;
                int[] nArray = new int[2];
                nArray[1] = 1;
                intValues = nArray;
                stringValues = new String[]{Babel.get("NO"), Babel.get("YES")};
            } else if (DEF_EXPORT_ADDRESS_MANDATORY.equals(valueType)) {
                prevVal = cvExportAdressMandatory;
                int[] nArray = new int[2];
                nArray[1] = 1;
                intValues = nArray;
                stringValues = new String[]{Babel.get("NO"), Babel.get("YES")};
            }
            int selectedInt = AllgChoiceRequester.getIntAnswer(sender, meldung, stringValues, intValues, -1, ArrayHelper.findIndexInArray(prevVal, intValues));
            if (selectedInt != -1 && selectedInt != prevVal) {
                Standards.setConfigInt(selectedInt, valueType);
            }
        }
        catch (Exception e) {
            String string = "Problem setting standard >" + valueType + "<";
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.util.ConfigManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, e, clazz);
        }
    }

    private static int[] getArray(int min, int max) {
        int[] res = new int[max - min + 1];
        int i = min;
        while (i <= max) {
            res[i - min] = i;
            ++i;
        }
        return res;
    }

    private static String[] getArray(int[] arr) {
        String[] res = new String[arr.length];
        int i = 0;
        while (i < res.length) {
            res[i] = Integer.toString(arr[i]);
            ++i;
        }
        return res;
    }

    public static boolean setConfigInt(int val, String valueType) {
        boolean res = false;
        if (ProcessDefinition.isClient()) {
            ObjectRequest or = new ObjectRequest(72, new Integer(val), UserManager.getFirstGroup(), valueType);
            if ((or = RequestManager.sendObjectRequestAndGetAnswer(or)) != null && or.isFinished()) {
                if (DEF_DORMANT_VAL.equals(valueType)) {
                    cvDormantThresholdInMillis = (long)val * 60000L;
                    res = true;
                } else if (DEF_MATURITY_VAL.equals(valueType)) {
                    cvMaturityLimitDays = val;
                    res = true;
                } else if (DEF_WEANING_VAL.equals(valueType)) {
                    cvWeaningLimitDays = val;
                    res = true;
                } else if (DEF_MIT_MATING_LINE_MAIL.equals(valueType)) {
                    cvMitMatingLineMail = val;
                    res = true;
                } else if (DEF_EXPORT_ADDRESS_MANDATORY.equals(valueType)) {
                    cvExportAdressMandatory = val;
                    res = true;
                }
            }
        }
        return res;
    }

    public static boolean setConfigInt(ObjectRequest or) {
        boolean res = false;
        if (ProcessDefinition.isServer() && or.ivObject != null && or.ivObject instanceof Integer) {
            int value = (Integer)or.ivObject;
            if (DEF_DORMANT_VAL.equals(or.ivExtraObject)) {
                value = Standards.checkLimits(value, 10, 120);
                cvDormantThresholdInMillis = (long)value * 60000L;
                res = FileManager.saveStringToFile("data/dormthr.txt", Long.toString(cvDormantThresholdInMillis));
            } else if (DEF_MATURITY_VAL.equals(or.ivExtraObject)) {
                cvMaturityLimitDays = value = Standards.checkLimits(value, cvMaturityMinValue, cvMaturityMaxValue);
                res = FileManager.saveStringToFile("data/matval.txt", Integer.toString(cvMaturityLimitDays));
            } else if (DEF_WEANING_VAL.equals(or.ivExtraObject)) {
                cvWeaningLimitDays = value = Standards.checkLimits(value, 10, 30);
                res = FileManager.saveStringToFile("data/weaning.txt", Integer.toString(cvWeaningLimitDays));
            } else if (DEF_MIT_MATING_LINE_MAIL.equals(or.ivExtraObject)) {
                cvMitMatingLineMail = value;
                res = FileManager.saveStringToFile("data/matlinmail.txt", Integer.toString(value));
            } else if (DEF_EXPORT_ADDRESS_MANDATORY.equals(or.ivExtraObject)) {
                cvExportAdressMandatory = value;
                res = FileManager.saveStringToFile("data/expadrmand.txt", Integer.toString(value));
            }
        }
        return res;
    }

    private static int checkLimits(int val, int min, int max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static int getConfigInt(ObjectRequest or) {
        String type;
        if (ProcessDefinition.isServer() && (type = (String)or.ivObject) != null) {
            if (DEF_DORMANT_VAL.equals(type)) {
                return (int)(cvDormantThresholdInMillis / 60000L);
            }
            if (DEF_MATURITY_VAL.equals(type)) {
                return cvMaturityLimitDays;
            }
            if (DEF_WEANING_VAL.equals(type)) {
                return cvWeaningLimitDays;
            }
            if (DEF_TIERSCHUTZ_VAL.equals(type)) {
                return TierSchutz.cvTierschutz;
            }
            if (DEF_SONDERREPORTS_VAL.equals(type)) {
                return SonderReports.cvSonderReports;
            }
            if (DEF_MIT_MATING_LINE_MAIL.equals(type)) {
                return cvMitMatingLineMail;
            }
            if (DEF_EXPORT_ADDRESS_MANDATORY.equals(type)) {
                return cvExportAdressMandatory;
            }
        }
        return -1;
    }

    public static int getConfigInt(String type, int defaultVal, int min, int max) {
        int res = defaultVal;
        if (ProcessDefinition.isClient()) {
            ObjectRequest mor = RequestManager.createSendAndGetAnswer((byte)71, type, "service", OAGetConfigValue.MARK_JUST_INTEGER);
            if (mor != null && mor.isFinished() && mor.ivObject != null && mor.ivObject instanceof Integer) {
                res = (Integer)mor.ivObject;
            }
        } else {
            String path = null;
            if (DEF_DORMANT_VAL.equals(type)) {
                path = "data/dormthr.txt";
            } else if (DEF_MATURITY_VAL.equals(type)) {
                path = "data/matval.txt";
            } else if (DEF_WEANING_VAL.equals(type)) {
                path = "data/weaning.txt";
            } else if (DEF_MIT_MATING_LINE_MAIL.equals(type)) {
                path = "data/matlinmail.txt";
            } else if (DEF_EXPORT_ADDRESS_MANDATORY.equals(type)) {
                path = "data/expadrmand.txt";
            }
            if (path != null) {
                try {
                    String s = FileManager.getStringFromFile(path);
                    if (s != null && s.length() != 0) {
                        res = DEF_DORMANT_VAL.equals(type) ? Standards.checkLimits((int)(Long.parseLong(s) / 60000L), min, max) : Standards.checkLimits(Integer.parseInt(s), min, max);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return res;
    }

    public static long getDormantThresholdInMillis() {
        return cvDormantThresholdInMillis;
    }

    public static int getMaturityLimitInDays() {
        return cvMaturityLimitDays;
    }

    public static long getWeanPeriodInMillis() {
        return (long)cvWeaningLimitDays * 86400000L;
    }

    public static int getWeanPeriodInDays() {
        return cvWeaningLimitDays;
    }

    public static boolean extendedAlertFoMatingWithoutMatchingLine() {
        return cvMitMatingLineMail == 1;
    }

    public static boolean isExportAdressManadatory() {
        return cvExportAdressMandatory == 1;
    }
}

