/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.util;

import java.awt.Color;
import java.awt.Image;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import mausoleum.helper.ImageProvider;

public abstract class SystemIconManager {
    private static final HashMap ICONS_BY_EXTENSION = new HashMap();
    private static final HashSet IMAGE_EXTENSIONS = new HashSet();
    private static final HashSet OFFICE_EXTENSIONS = new HashSet();
    private static final HashSet PLAIN_EXTENSIONS = new HashSet();
    private static final String UNKNOWN_EXTENSION = "UNKNOWN";
    private static final String[] EXCEL = new String[]{"     4444444444     ", "     42222222241    ", "  545422245422421   ", "  4545424545221111  ", "  5254545454333231  ", "   525454543223231  ", "    52545433333231  ", "   545254545223231  ", "  5454525454333231  ", "  4545452545222231  ", "  5454545254523231  ", "     4222545423231  ", "     4233332333231  ", "     4222222222231  ", "     4333333333331  ", "     4111111111111  "};
    private static final int[] EXCEL_COLORS = new int[]{ImageProvider.COL_DURCHSICHTIG, ImageProvider.COL_BLACK, ImageProvider.COL_WHITE, new Color(198, 198, 198).getRGB(), new Color(132, 132, 132).getRGB(), new Color(0, 132, 0).getRGB()};
    private static final String[] MAIL = new String[]{"                    ", "                    ", "  333333333333333   ", "  3322222222222331  ", "  3232222222223231  ", "  3223222222232231  ", "  3222322222322231  ", "  3223232223232231  ", "  3232223232223231  ", "  3322222322222331  ", "  3222222222222231  ", "  3222222222222231  ", "  3333333333333331  ", "   111111111111111  ", "                    ", "                    "};
    private static final int[] MAIL_COLORS = new int[]{ImageProvider.COL_DURCHSICHTIG, ImageProvider.COL_BLACK, ImageProvider.COL_WHITE, new Color(153, 153, 153).getRGB()};
    private static final String[] MPG = new String[]{"     4444444444     ", "     42222222241    ", "     422222222421   ", "     4222222221111  ", "  11 4222222222231  ", "  61 4222222222231  ", "  6566666666224431  ", "  6155515556164131  ", "  1111155556153131  ", "   165555556116131  ", "   164551516121131  ", "   111111161122231  ", "     4222222222231  ", "     4222222222231  ", "     4333333333331  ", "     4111111111111  "};
    private static final int[] MPG_COLORS = new int[]{ImageProvider.COL_DURCHSICHTIG, ImageProvider.COL_BLACK, ImageProvider.COL_WHITE, new Color(198, 198, 198).getRGB(), new Color(132, 132, 132).getRGB(), new Color(0, 255, 255).getRGB(), new Color(0, 132, 132).getRGB()};
    private static final String[] PPT = new String[]{"     4444444444     ", "     42222222241    ", "  565656565622421   ", "  6222222225221111  ", "  5656565656333231  ", "  6525252525222231  ", "  5626262626333231  ", "  6565652525222231  ", "  5626222626333231  ", "  6525222525222231  ", "  5222222226222231  ", "  6565656565233331  ", "     4222222222231  ", "     4222222222231  ", "     4333333333331  ", "     4111111111111  "};
    private static final int[] PPT_COLORS = new int[]{ImageProvider.COL_DURCHSICHTIG, ImageProvider.COL_BLACK, ImageProvider.COL_WHITE, new Color(198, 198, 198).getRGB(), new Color(132, 132, 132).getRGB(), new Color(255, 0, 0).getRGB(), new Color(132, 132, 0).getRGB()};
    private static final String[] ALLG = new String[]{" 4444444444    ", " 42222222241   ", " 422222222421  ", " 4222222221111 ", " 4222222222231 ", " 4222222222231 ", " 4222222222231 ", " 4222222222231 ", " 4222222222231 ", " 4222222222231 ", " 4222222222231 ", " 4222222222231 ", " 4222222222231 ", " 4222222222231 ", " 4333333333331 ", " 4111111111111 "};
    private static final String[] TXT = new String[]{"     4444444444     ", "     42222222241    ", "     421111122421   ", "     4222222221111  ", "     4211122112231  ", "     4222222222231  ", "     4211111122231  ", "     4222222222231  ", "     4211221121231  ", "     4222222222231  ", "     4212111122231  ", "     4222222222231  ", "     4211111211231  ", "     4222222222231  ", "     4333333333331  ", "     4111111111111  "};
    private static final int[] TXT_COLORS = new int[]{ImageProvider.COL_DURCHSICHTIG, ImageProvider.COL_BLACK, ImageProvider.COL_WHITE, new Color(198, 198, 198).getRGB(), new Color(132, 132, 132).getRGB()};
    private static final int[] TXT_COLORS_BLUE = new int[]{ImageProvider.COL_DURCHSICHTIG, ImageProvider.COL_BLACK, new Color(206, 231, 255).getRGB(), new Color(198, 198, 198).getRGB(), new Color(132, 132, 132).getRGB()};
    private static final String[] WORD = new String[]{"     4444444444     ", "     42222222241    ", "  565656565622421   ", "  6222222225221111  ", "  5656565656333231  ", "  6562652565222231  ", "  5252562626323231  ", "  6265656525222231  ", "  5256265226333231  ", "  6265256225222231  ", "  5222222226333231  ", "  6565656565222231  ", "     4222223333231  ", "     4222222222231  ", "     4333333333331  ", "     4111111111111  "};
    private static final int[] WORD_COLORS = new int[]{ImageProvider.COL_DURCHSICHTIG, ImageProvider.COL_BLACK, ImageProvider.COL_WHITE, new Color(198, 198, 198).getRGB(), new Color(132, 132, 132).getRGB(), new Color(0, 0, 255).getRGB(), new Color(0, 0, 0).getRGB()};
    private static final String[] XML = new String[]{"     4444444444     ", "     42222222241    ", "  555555555555521   ", "  5252525552525111  ", "  5252522522525231  ", "  5525525252525231  ", "  5252525552522231  ", "  5555555555522231  ", "     4223333332231  ", "     4222222222231  ", "     4223333332231  ", "     4222222222231  ", "     4223333332231  ", "     4222222222231  ", "     4333333333331  ", "     4111111111111  "};
    private static final int[] XML_COLORS = new int[]{ImageProvider.COL_DURCHSICHTIG, ImageProvider.COL_BLACK, ImageProvider.COL_WHITE, new Color(198, 198, 198).getRGB(), new Color(132, 132, 132).getRGB(), new Color(255, 102, 0).getRGB()};
    private static final String[] UNBEKANNT = new String[]{"     4444444444     ", "     42222222241    ", "     422255555421   ", "     4225555555111  ", "     4225556255561  ", "     4222662255561  ", "     4222225555631  ", "     4222255562231  ", "     4222255562231  ", "     4222255562231  ", "     4222226662231  ", "     4222255522231  ", "     4222255562231  ", "     4222255562231  ", "     4333336663331  ", "     4111111111111  "};
    private static final int[] UNBEKANNT_COLORS = new int[]{ImageProvider.COL_DURCHSICHTIG, ImageProvider.COL_BLACK, ImageProvider.COL_WHITE, new Color(198, 198, 198).getRGB(), new Color(132, 132, 132).getRGB(), new Color(255, 0, 0).getRGB(), new Color(80, 0, 0).getRGB()};
    private static final String[] PDF = new String[]{"     4444444444     ", "     42222222241    ", "     422222222421   ", "  4444444444221111  ", "  4555555554222231  ", "  4444444444222231  ", "     4222662222231  ", "     4222782222231  ", "     4222676222231  ", "     4222878222231  ", "     4227626666631  ", "     4226222222231  ", "     4686222222231  ", "     4882222222231  ", "     4833333333331  ", "     4111111111111  "};
    private static final int[] PDF_COLORS = new int[]{ImageProvider.COL_DURCHSICHTIG, ImageProvider.COL_BLACK, ImageProvider.COL_WHITE, new Color(198, 198, 198).getRGB(), new Color(132, 132, 132).getRGB(), new Color(255, 0, 0).getRGB(), new Color(170, 170, 170).getRGB(), new Color(187, 187, 187).getRGB(), new Color(102, 102, 102).getRGB()};
    private static final String[] ZIP = new String[]{"        1111111     ", "       133333331    ", "   111 1111111131   ", "  144412222222131   ", "  144411111112131   ", "  144444444412131   ", "  144444444412131   ", "  144444444412131   ", "  144444444412131   ", "  144444444412131   ", "  111111111111131   ", "       1333333331   ", "        11111111    ", "            131     ", "         11131111   ", "         1111 111   "};
    private static final int[] ZIP_COLORS = new int[]{ImageProvider.COL_DURCHSICHTIG, ImageProvider.COL_BLACK, ImageProvider.COL_WHITE, new Color(189, 189, 189).getRGB(), new Color(243, 224, 13).getRGB()};
    private static final ImageIcon UNKNOWN_ICON = new ImageIcon(ImageProvider.generateImage(UNBEKANNT, UNBEKANNT_COLORS));
    private static final Image MAIL_IMAGE = ImageProvider.generateImage(MAIL, MAIL_COLORS);
    private static final String[] EXCEL_KEYS = new String[]{".xls", ".xlsx"};
    private static final String[] MAIL_KEYS = new String[]{".msg", ".eml"};
    private static final String[] IMAGE_KEYS = new String[]{".mpg", ".avi", ".mov", ".wmv", ".mp3", ".mp4", ".wav", ".tif", ".tiff", ".bmp", ".png", ".gif", ".jpg", ".jpeg"};
    private static final String[] POWERPOINT_KEYS = new String[]{".ppt", ".pptx"};
    private static final String[] TEXT_KEYS = new String[]{".txt", ".log", ".dat", ".ini", ".text"};
    private static final String[] WORD_KEYS = new String[]{".doc", ".dot", ".docx"};
    private static final String[] XML_KEYS = new String[]{".xml", ".xxml"};
    private static final String[] ZIP_KEYS = new String[]{".zip"};
    private static final String[] PDF_KEYS = new String[]{".pdf", ".epdf", ".ics", ".rfc"};

    static {
        SystemIconManager.addIcon(ImageProvider.generateImage(EXCEL, EXCEL_COLORS), EXCEL_KEYS);
        SystemIconManager.addIcon(MAIL_IMAGE, MAIL_KEYS);
        SystemIconManager.addIcon(ImageProvider.generateImage(MPG, MPG_COLORS), IMAGE_KEYS);
        SystemIconManager.addIcon(ImageProvider.generateImage(PPT, PPT_COLORS), POWERPOINT_KEYS);
        SystemIconManager.addIcon(ImageProvider.generateImage(TXT, TXT_COLORS), TEXT_KEYS);
        SystemIconManager.addIcon(ImageProvider.generateImage(WORD, WORD_COLORS), WORD_KEYS);
        SystemIconManager.addIcon(ImageProvider.generateImage(XML, XML_COLORS), XML_KEYS);
        SystemIconManager.addIcon(ImageProvider.generateImage(ZIP, ZIP_COLORS), ZIP_KEYS);
        SystemIconManager.addIcon(ImageProvider.generateImage(PDF, PDF_COLORS), PDF_KEYS);
        ICONS_BY_EXTENSION.put(UNKNOWN_EXTENSION, UNKNOWN_ICON);
        IMAGE_EXTENSIONS.add(".tif");
        IMAGE_EXTENSIONS.add(".tiff");
        IMAGE_EXTENSIONS.add(".bmp");
        IMAGE_EXTENSIONS.add(".png");
        IMAGE_EXTENSIONS.add(".gif");
        IMAGE_EXTENSIONS.add(".jpg");
        IMAGE_EXTENSIONS.add(".jpeg");
        OFFICE_EXTENSIONS.add(".doc");
        OFFICE_EXTENSIONS.add(".dot");
        OFFICE_EXTENSIONS.add(".docx");
        OFFICE_EXTENSIONS.add(".ppt");
        OFFICE_EXTENSIONS.add(".pptx");
        OFFICE_EXTENSIONS.add(".xls");
        OFFICE_EXTENSIONS.add(".xlsx");
        PLAIN_EXTENSIONS.add(".xml");
        PLAIN_EXTENSIONS.add(".xxml");
        PLAIN_EXTENSIONS.add(".txt");
        PLAIN_EXTENSIONS.add(".log");
        PLAIN_EXTENSIONS.add(".text");
    }

    public static ImageIcon getTextIcon() {
        return (ImageIcon)ICONS_BY_EXTENSION.get(".txt");
    }

    public static Icon getIcon(String filename) {
        String key = SystemIconManager.getKey(filename);
        ImageIcon hauptIcon = (ImageIcon)ICONS_BY_EXTENSION.get(key);
        if (hauptIcon == null) {
            hauptIcon = UNKNOWN_ICON;
        }
        return hauptIcon;
    }

    public static String getKey(String filename) {
        int ind;
        if (filename != null && (ind = filename.lastIndexOf(".")) != -1) {
            return filename.substring(ind, filename.length()).toLowerCase().trim();
        }
        return UNKNOWN_EXTENSION;
    }

    public static boolean isImage(String filename) {
        return SystemIconManager.belongsTo(filename, IMAGE_EXTENSIONS);
    }

    public static boolean isOffice(String filename) {
        return SystemIconManager.belongsTo(filename, OFFICE_EXTENSIONS);
    }

    public static boolean isPlain(String filename) {
        return SystemIconManager.belongsTo(filename, PLAIN_EXTENSIONS);
    }

    private static boolean belongsTo(String filename, HashSet hs) {
        int ind;
        if (filename != null && (ind = filename.lastIndexOf(".")) != -1) {
            return hs.contains(filename.substring(ind, filename.length()).toLowerCase().trim());
        }
        return false;
    }

    private static void addIcon(Image image, String[] keys) {
        ImageIcon ico = new ImageIcon(image);
        int i = 0;
        while (i < keys.length) {
            ICONS_BY_EXTENSION.put(keys[i], ico);
            ++i;
        }
    }
}

