/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.util.calendar;

import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import mausoleum.gui.MGButton;
import mausoleum.helper.FontManager;
import mausoleum.ui.UIDef;
import mausoleum.util.calendar.InstituteHolidayDialog;
import mausoleum.util.calendar.InstituteHolidays;

public class AddedHolidaysTable
extends JTable {
    private static final long serialVersionUID = 1456432L;
    private JLabel ivTableLabel = new JLabel();
    private MGButton ivHeaderButton = MGButton.getInspectorActionButton("", "");
    private Vector ivAddedHolidayInfos = new Vector();
    static /* synthetic */ Class class$0;

    public AddedHolidaysTable() {
        this.setModel(new TableModel(){

            public int getRowCount() {
                return AddedHolidaysTable.this.ivAddedHolidayInfos.size();
            }

            public int getColumnCount() {
                return 3;
            }

            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return Babel.get("HOLIDAY");
                    }
                    case 1: {
                        return Babel.get("DATE");
                    }
                    case 2: {
                        return Babel.get("YEARS");
                    }
                }
                return "";
            }

            public Class getColumnClass(int arg0) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }

            public boolean isCellEditable(int row, int column) {
                return false;
            }

            public Object getValueAt(int row, int column) {
                if (row >= 0 && row < AddedHolidaysTable.this.ivAddedHolidayInfos.size()) {
                    int[] arr;
                    InstituteHolidays.HolidayInfo hdi = (InstituteHolidays.HolidayInfo)AddedHolidaysTable.this.ivAddedHolidayInfos.elementAt(row);
                    if (column == 0) {
                        return hdi.ivHolidayDef.getDisplay();
                    }
                    if (column == 1) {
                        return hdi.ivHolidayDef.gibtsMich(InstituteHolidayDialog.cvSelectedYear) ? hdi.getDateDisplay() : Babel.get("NOT_IN_SELECTED_YEAR");
                    }
                    if (column == 2 && (arr = hdi.ivHolidayDef.ivYearRestrictions) != null) {
                        if (arr.length == 1 && arr[0] != -1) {
                            return Integer.toString(arr[0]);
                        }
                        if (arr.length == 2) {
                            if (arr[0] != -1 && arr[1] != -1) {
                                return String.valueOf(Integer.toString(arr[0])) + " - " + Integer.toString(arr[1]);
                            }
                            if (arr[0] == -1 && arr[1] != -1) {
                                return " - " + Integer.toString(arr[1]);
                            }
                            if (arr[0] != -1 && arr[1] == -1) {
                                return String.valueOf(Integer.toString(arr[0])) + " - ";
                            }
                        }
                    }
                }
                return "";
            }

            public void setValueAt(Object arg0, int arg1, int arg2) {
            }

            public void addTableModelListener(TableModelListener arg0) {
            }

            public void removeTableModelListener(TableModelListener arg0) {
            }
        });
        this.getSelectionModel().setSelectionMode(0);
        this.getTableHeader().setPreferredSize(new Dimension(UIDef.getScaled(100), UIDef.getScaled(20)));
        this.setOpaque(false);
        this.getTableHeader().setDefaultRenderer(new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                AddedHolidaysTable.this.ivHeaderButton.setLabel(" " + AddedHolidaysTable.this.getColumnName(column) + " ");
                return AddedHolidaysTable.this.ivHeaderButton;
            }
        });
        this.ivTableLabel.setOpaque(true);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setDefaultRenderer(clazz, new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                AddedHolidaysTable.this.ivTableLabel.setText(" " + value + " ");
                AddedHolidaysTable.this.ivTableLabel.setBackground(isSelected ? UIDef.SELECTED_BACKGROUND : Color.white);
                InstituteHolidays.HolidayInfo hdi = (InstituteHolidays.HolidayInfo)AddedHolidaysTable.this.ivAddedHolidayInfos.elementAt(row);
                if (hdi.ivHolidayDef.gibtsMich(InstituteHolidayDialog.cvSelectedYear)) {
                    AddedHolidaysTable.this.ivTableLabel.setFont(FontManager.getFont("SSB11"));
                } else {
                    AddedHolidaysTable.this.ivTableLabel.setFont(FontManager.getFont("SSP11"));
                }
                AddedHolidaysTable.this.ivTableLabel.setForeground(hdi.ivMode == 2 ? InstituteHolidayDialog.ADDED_FOREGROUND : InstituteHolidayDialog.PRIVATE_FOREGROUND);
                AddedHolidaysTable.this.ivTableLabel.setHorizontalAlignment(column == 0 ? 2 : 0);
                return AddedHolidaysTable.this.ivTableLabel;
            }
        });
        this.setData(null);
    }

    public void addTableModelListener(TableModelListener l) {
    }

    public void removeTableModelListener(TableModelListener l) {
    }

    public void setData(Vector allHDIs) {
        this.ivAddedHolidayInfos.clear();
        if (allHDIs != null && !allHDIs.isEmpty()) {
            Iterator iterator = allHDIs.iterator();
            while (iterator.hasNext()) {
                InstituteHolidays.HolidayInfo hdi = (InstituteHolidays.HolidayInfo)iterator.next();
                if (hdi.ivMode == 1) continue;
                this.ivAddedHolidayInfos.add(hdi);
            }
            this.tableChanged(new TableModelEvent(this.getModel()));
        }
    }

    public InstituteHolidays.HolidayInfo getSelectedInfo() {
        int ind = this.getSelectedRow();
        if (ind >= 0 && ind < this.ivAddedHolidayInfos.size()) {
            return (InstituteHolidays.HolidayInfo)this.ivAddedHolidayInfos.elementAt(ind);
        }
        return null;
    }

    public void select(InstituteHolidays.HolidayInfo hdi) {
        int ind;
        if (hdi != null && (ind = this.ivAddedHolidayInfos.indexOf(hdi)) != -1) {
            this.getSelectionModel().setSelectionInterval(ind, ind);
            return;
        }
        this.clearSelection();
    }
}

