/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.util.calendar;

import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import mausoleum.gui.KomfortTextField;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.WindowUtils;
import mausoleum.ui.UIDef;
import mausoleum.util.calendar.HolidayDef;
import mausoleum.util.calendar.InstituteHolidayDialog;
import mausoleum.util.calendar.InstituteHolidays;

public class SpecifyPrivateHolidayDialog
extends JDialog {
    private static final long serialVersionUID = 115831483438345L;
    private static final int ROW_NAME = 0;
    private static final int ROW_MONTH = 1;
    private static final int ROW_DAY = 2;
    private static final int ROW_YEAR_MODE = 3;
    private static final int ROW_YEAR1 = 4;
    private static final int ROW_YEAR2 = 5;
    private static final HashMap DAY_COMBO_MODELS = new HashMap();
    private static final int YEAR_MODE_IMMER = 0;
    private static final int YEAR_MODE_GENAU = 1;
    private static final int YEAR_MODE_AB = 2;
    private static final int YEAR_MODE_BIS = 3;
    private static final int YEAR_MODE_ZWISCHEN = 4;
    private static SpecifyPrivateHolidayDialog cvInstance = null;
    private JLabel[] ivLabels = new JLabel[]{new JLabel(Babel.get("HOLIDAY")), new JLabel(Babel.get("MONTH")), new JLabel(Babel.get("DAY")), new JLabel(Babel.get("HYM_YEAR_MODE")), new JLabel(Babel.get("HYM_JAHR1")), new JLabel(Babel.get("HYM_JAHR2"))};
    private JComponent[] ivComps;
    private MGButton ivOKButton;
    private MGButton ivNOButton;
    private int[] ivYear1Modes;
    private int[] ivYear2Modes;
    private int ivLeftWidth;
    private int ivRightWidth;
    private int ivWantedWidth;
    private int ivWantedHeight;
    private boolean ivWarOK;
    private ActionListener ivCheckOk;

    public static HolidayDef specifyPrivateHoliday(InstituteHolidays.HolidayInfo hdi) {
        if (cvInstance == null) {
            cvInstance = new SpecifyPrivateHolidayDialog();
        }
        cvInstance.adapt(hdi);
        WindowUtils.bringUpCenteredDialog(cvInstance, SpecifyPrivateHolidayDialog.cvInstance.ivWantedWidth, SpecifyPrivateHolidayDialog.cvInstance.ivWantedHeight, true);
        if (SpecifyPrivateHolidayDialog.cvInstance.ivWarOK) {
            if (hdi == null) {
                HolidayDef hd = new HolidayDef();
                cvInstance.fillResult(hd);
                return hd;
            }
            cvInstance.fillResult(hdi.ivHolidayDef);
            return hdi.ivHolidayDef;
        }
        return null;
    }

    private SpecifyPrivateHolidayDialog() {
        JComponent[] jComponentArray = new JComponent[6];
        jComponentArray[0] = new KomfortTextField();
        jComponentArray[1] = new JComboBox<String>(DatumFormat.getBigMonths());
        jComponentArray[2] = new JComboBox();
        jComponentArray[3] = new JComboBox<String>(new String[]{Babel.get("HYM_IMMER"), Babel.get("HYM_EIN_JAHR"), Babel.get("HYM_AB"), Babel.get("HYM_BIS"), Babel.get("HYM_ZWISCHEN")});
        this.ivComps = jComponentArray;
        this.ivOKButton = MGButton.getRequesterButton(Babel.get("YES"));
        this.ivNOButton = MGButton.getRequesterButton(Babel.get("NO"));
        this.ivYear1Modes = new int[]{1, 2, 4};
        this.ivYear2Modes = new int[]{3, 4};
        this.ivLeftWidth = 0;
        this.ivRightWidth = UIDef.getScaled(250);
        this.ivWantedWidth = 0;
        this.ivWantedHeight = 0;
        this.ivWarOK = false;
        this.ivCheckOk = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SpecifyPrivateHolidayDialog.this.ivOKButton.setEnabled(SpecifyPrivateHolidayDialog.this.isOK());
            }
        };
        this.setModal(true);
        RequesterPane pane = new RequesterPane(new SimpleLayoutManager(){

            public void layoutContainer(Container parent) {
                int xl = UIDef.RAND;
                int xr = xl + SpecifyPrivateHolidayDialog.this.ivLeftWidth + UIDef.INNER_RAND;
                int y = UIDef.RAND;
                int row = 0;
                while (row < SpecifyPrivateHolidayDialog.this.ivLabels.length) {
                    SpecifyPrivateHolidayDialog.this.ivLabels[row].setBounds(xl, y, SpecifyPrivateHolidayDialog.this.ivLeftWidth, UIDef.LINE_HEIGHT);
                    SpecifyPrivateHolidayDialog.this.ivComps[row].setBounds(xr, y, SpecifyPrivateHolidayDialog.this.ivRightWidth, UIDef.LINE_HEIGHT);
                    y += UIDef.LINE_HEIGHT + UIDef.INNER_RAND;
                    ++row;
                }
                int iw = parent.getSize().width - 2 * UIDef.RAND;
                int lw = (iw - UIDef.INNER_RAND) / 2;
                int rw = iw - UIDef.INNER_RAND - lw;
                SpecifyPrivateHolidayDialog.this.ivOKButton.setBounds(xl, y, lw, UIDef.BUT_HEIGHT);
                SpecifyPrivateHolidayDialog.this.ivNOButton.setBounds(xl + lw + UIDef.INNER_RAND, y, rw, UIDef.BUT_HEIGHT);
            }
        });
        ((KomfortTextField)this.ivComps[0]).addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                SpecifyPrivateHolidayDialog.this.ivCheckOk.actionPerformed(null);
            }
        });
        this.ivComps[4] = new JComboBox(InstituteHolidayDialog.cvAllYears);
        ((JComboBox)this.ivComps[4]).setSelectedItem(new Integer(InstituteHolidayDialog.cvThisYear));
        this.ivComps[5] = new JComboBox(InstituteHolidayDialog.cvAllYears);
        ((JComboBox)this.ivComps[5]).setSelectedItem(new Integer(InstituteHolidayDialog.cvThisYear));
        ((JComboBox)this.ivComps[4]).addActionListener(this.ivCheckOk);
        ((JComboBox)this.ivComps[5]).addActionListener(this.ivCheckOk);
        ((JComboBox)this.ivComps[3]).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SpecifyPrivateHolidayDialog.this.ivLabels[4].setVisible(SpecifyPrivateHolidayDialog.this.yearPossible(true));
                SpecifyPrivateHolidayDialog.this.ivComps[4].setVisible(SpecifyPrivateHolidayDialog.this.yearPossible(true));
                SpecifyPrivateHolidayDialog.this.ivLabels[5].setVisible(SpecifyPrivateHolidayDialog.this.yearPossible(false));
                SpecifyPrivateHolidayDialog.this.ivComps[5].setVisible(SpecifyPrivateHolidayDialog.this.yearPossible(false));
                SpecifyPrivateHolidayDialog.this.getContentPane().repaint();
            }
        });
        ((JComboBox)this.ivComps[3]).setSelectedIndex(0);
        ((JComboBox)this.ivComps[1]).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int timNachher;
                JComboBox combo = (JComboBox)SpecifyPrivateHolidayDialog.this.ivComps[2];
                int timVorher = combo.getModel().getSize();
                if (timVorher != (timNachher = MyDate.getTageImMonat(((JComboBox)SpecifyPrivateHolidayDialog.this.ivComps[1]).getSelectedIndex() + 1, InstituteHolidayDialog.cvThisYear))) {
                    Integer key = new Integer(timNachher);
                    DefaultComboBoxModel<Integer> model = (DefaultComboBoxModel<Integer>)DAY_COMBO_MODELS.get(key);
                    if (model == null) {
                        Integer[] vals = new Integer[timNachher];
                        int i = 0;
                        while (i < vals.length) {
                            vals[i] = new Integer(i + 1);
                            ++i;
                        }
                        model = new DefaultComboBoxModel<Integer>(vals);
                        DAY_COMBO_MODELS.put(key, model);
                    }
                    combo.setModel(model);
                }
            }
        });
        ((JComboBox)this.ivComps[1]).setSelectedIndex(0);
        int i = 0;
        while (i < this.ivLabels.length) {
            pane.add(this.ivLabels[i]);
            pane.add(this.ivComps[i]);
            if (this.ivLabels[i].getPreferredSize().width > this.ivLeftWidth) {
                this.ivLeftWidth = this.ivLabels[i].getPreferredSize().width;
            }
            ++i;
        }
        this.ivOKButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SpecifyPrivateHolidayDialog.this.ivWarOK = true;
                SpecifyPrivateHolidayDialog.this.setVisible(false);
            }
        });
        pane.add(this.ivOKButton);
        this.ivNOButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SpecifyPrivateHolidayDialog.this.ivWarOK = false;
                SpecifyPrivateHolidayDialog.this.setVisible(false);
            }
        });
        pane.add(this.ivNOButton);
        this.ivWantedWidth = UIDef.RAND + this.ivLeftWidth + UIDef.INNER_RAND + this.ivRightWidth + UIDef.RAND;
        this.ivWantedHeight = UIDef.RAND + this.ivComps.length * (UIDef.LINE_HEIGHT + UIDef.INNER_RAND) + UIDef.BUT_HEIGHT + UIDef.RAND;
        this.ivCheckOk.actionPerformed(null);
        this.setContentPane(pane);
        this.setResizable(false);
    }

    private boolean yearPossible(boolean year1) {
        return ArrayHelper.findIndexInArray(((JComboBox)this.ivComps[3]).getSelectedIndex(), year1 ? this.ivYear1Modes : this.ivYear2Modes) != -1;
    }

    private boolean isOK() {
        if (((KomfortTextField)this.ivComps[0]).getText().trim().length() == 0) {
            return false;
        }
        if (this.yearPossible(true) && this.yearPossible(false)) {
            Integer i1 = (Integer)((JComboBox)this.ivComps[4]).getSelectedItem();
            Integer i2 = (Integer)((JComboBox)this.ivComps[5]).getSelectedItem();
            if (i1 > i2) {
                return false;
            }
        }
        return true;
    }

    private void adapt(InstituteHolidays.HolidayInfo hdi) {
        Integer tyI = new Integer(InstituteHolidayDialog.cvThisYear);
        ((JComboBox)this.ivComps[4]).setSelectedItem(tyI);
        ((JComboBox)this.ivComps[5]).setSelectedItem(tyI);
        if (hdi == null || hdi.ivHolidayDef == null) {
            ((KomfortTextField)this.ivComps[0]).setText("");
            ((JComboBox)this.ivComps[1]).setSelectedIndex(0);
            ((JComboBox)this.ivComps[2]).setSelectedIndex(0);
            ((JComboBox)this.ivComps[3]).setSelectedIndex(0);
        } else {
            HolidayDef hd = hdi.ivHolidayDef;
            ((KomfortTextField)this.ivComps[0]).setText(hd.ivKennung);
            ((JComboBox)this.ivComps[1]).setSelectedIndex(hd.ivFixedMonth - 1);
            ((JComboBox)this.ivComps[2]).setSelectedIndex(hd.ivFixedDay - 1);
            if (hd.ivYearRestrictions == null || hd.ivYearRestrictions.length == 0) {
                ((JComboBox)this.ivComps[3]).setSelectedIndex(0);
            } else if (hd.ivYearRestrictions.length == 1) {
                ((JComboBox)this.ivComps[3]).setSelectedIndex(1);
                ((JComboBox)this.ivComps[4]).setSelectedItem(new Integer(hd.ivYearRestrictions[0]));
            } else if (hd.ivYearRestrictions.length == 2) {
                if (hd.ivYearRestrictions[1] == -1) {
                    ((JComboBox)this.ivComps[3]).setSelectedIndex(2);
                    ((JComboBox)this.ivComps[4]).setSelectedItem(new Integer(hd.ivYearRestrictions[0]));
                } else if (hd.ivYearRestrictions[0] == -1) {
                    ((JComboBox)this.ivComps[3]).setSelectedIndex(3);
                    ((JComboBox)this.ivComps[5]).setSelectedItem(new Integer(hd.ivYearRestrictions[1]));
                } else {
                    ((JComboBox)this.ivComps[3]).setSelectedIndex(4);
                    ((JComboBox)this.ivComps[4]).setSelectedItem(new Integer(hd.ivYearRestrictions[0]));
                    ((JComboBox)this.ivComps[5]).setSelectedItem(new Integer(hd.ivYearRestrictions[1]));
                }
            }
        }
    }

    private void fillResult(HolidayDef hd) {
        hd.ivKennung = ((KomfortTextField)this.ivComps[0]).getText().trim();
        hd.ivFixedDay = ((JComboBox)this.ivComps[2]).getSelectedIndex() + 1;
        hd.ivFixedMonth = ((JComboBox)this.ivComps[1]).getSelectedIndex() + 1;
        hd.ivWeekday = -1;
        int mode = ((JComboBox)this.ivComps[3]).getSelectedIndex();
        if (mode == 0) {
            hd.ivYearRestrictions = null;
        } else if (mode == 1) {
            Integer i1 = (Integer)((JComboBox)this.ivComps[4]).getSelectedItem();
            hd.ivYearRestrictions = new int[]{i1};
        } else if (mode == 2) {
            Integer i1 = (Integer)((JComboBox)this.ivComps[4]).getSelectedItem();
            hd.ivYearRestrictions = new int[]{i1, -1};
        } else if (mode == 3) {
            Integer i2 = (Integer)((JComboBox)this.ivComps[5]).getSelectedItem();
            hd.ivYearRestrictions = new int[]{-1, i2};
        } else if (mode == 4) {
            Integer i1 = (Integer)((JComboBox)this.ivComps[4]).getSelectedItem();
            Integer i2 = (Integer)((JComboBox)this.ivComps[5]).getSelectedItem();
            hd.ivYearRestrictions = new int[]{i1, i2};
        }
    }
}

