/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.visit;

import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.helper.LongPunkt;

public class Visit
implements Externalizable {
    static final long serialVersionUID = -8717671986526504937L;
    public static final int NEVER_HAPPENED = -1;
    public static final int UNDEFINED = 0;
    public static final int BIRTH = 1;
    public static final int TRANSFER = 2;
    public static final int IMPORT = 3;
    public static final int DEATH = 4;
    public static final int SACRIFICE = 5;
    public static final int EXPORT = 6;
    public static final int TRANSFER_FROM_MATING = 7;
    public static final int REMOVAL = 8;
    public static final int GROUP_TRANSFER = 9;
    public static final int DIGITAL_NIRVANA = 10;
    public static final int BIRTH_FROM_EMBRYO_TRANSFER = 11;
    public static final int[] MODI;
    public static final String[] MODI_BABELS;
    public long ivCageID = 0L;
    public long ivMouseID = 0L;
    public Date ivStartDate = null;
    public Date ivEndDate = null;
    public int ivStartMode = 0;
    public int ivEndMode = 0;

    static {
        int[] nArray = new int[12];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 7;
        nArray[4] = 3;
        nArray[5] = 4;
        nArray[6] = 5;
        nArray[7] = 6;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        MODI = nArray;
        MODI_BABELS = new String[]{"UNDEFINED", "BYBIRTH", "BYTRANSFER", "BYTRANSFER", "BYIMPORT", "BYDEATH", "BYSACRIFICE", "BYEXPORT", "BYREMOVAL", "BYGROUPTRANSFER", "BYDIGITALNIRVANA", "BYBIRTHFROMEMBRYOTRANSFER"};
    }

    public static Visit findLatestUnfinishedVisit(Visit[] visitArray, long mouseID, long cageID) {
        long lastStartMillis = Long.MIN_VALUE;
        Visit res = null;
        if (visitArray != null && visitArray.length != 0 && mouseID != 0L && cageID != 0L) {
            int i = 0;
            while (i < visitArray.length) {
                long vsdm;
                if (visitArray[i].ivEndDate == null && visitArray[i].ivMouseID == mouseID && visitArray[i].ivCageID == cageID && visitArray[i].ivStartDate != null && (vsdm = visitArray[i].ivStartDate.getTime()) > lastStartMillis) {
                    lastStartMillis = vsdm;
                    res = visitArray[i];
                }
                ++i;
            }
        }
        return res;
    }

    public static Visit findLatestUnfinishedVisit(Visit[] visits) {
        Visit res = null;
        if (visits != null) {
            long start = Long.MIN_VALUE;
            int i = 0;
            while (i < visits.length) {
                long vmillis;
                if (visits[i].ivEndDate == null && visits[i].ivStartDate != null && (vmillis = visits[i].ivStartDate.getTime()) > start) {
                    start = vmillis;
                    res = visits[i];
                }
                ++i;
            }
        }
        return res;
    }

    public static Vector collectUnfinishedVisits(Visit[] arr) {
        Vector<Visit> res = new Vector<Visit>();
        int i = 0;
        while (i < arr.length) {
            if (arr[i].ivEndDate == null) {
                res.add(arr[i]);
            }
            ++i;
        }
        return res;
    }

    public static Visit findExtactlyThisVisit(Visit[] arr, Visit model) {
        if (arr != null && model != null) {
            int i = 0;
            while (i < arr.length) {
                if (model.equals(arr[i])) {
                    return arr[i];
                }
                ++i;
            }
        }
        return null;
    }

    public static Visit findlastVisit(Visit[] visitArray, long mouseID, long cageID) {
        long lastStartMillis = Long.MIN_VALUE;
        Visit res = null;
        if (visitArray != null && visitArray.length != 0 && mouseID != 0L && cageID != 0L) {
            int i = 0;
            while (i < visitArray.length) {
                long vsdm;
                if (visitArray[i].ivMouseID == mouseID && visitArray[i].ivCageID == cageID && visitArray[i].ivStartDate != null && (vsdm = visitArray[i].ivStartDate.getTime()) > lastStartMillis) {
                    lastStartMillis = vsdm;
                    res = visitArray[i];
                }
                ++i;
            }
        }
        return res;
    }

    public static Visit findFirstVisit(Visit[] visitArray, long mouseID, long cageID) {
        long firstStartMillis = Long.MAX_VALUE;
        Visit res = null;
        if (visitArray != null && visitArray.length != 0 && mouseID != 0L && cageID != 0L) {
            int i = 0;
            while (i < visitArray.length) {
                long vsdm;
                if (visitArray[i].ivMouseID == mouseID && visitArray[i].ivCageID == cageID && visitArray[i].ivStartDate != null && (vsdm = visitArray[i].ivStartDate.getTime()) < firstStartMillis) {
                    firstStartMillis = vsdm;
                    res = visitArray[i];
                }
                ++i;
            }
        }
        return res;
    }

    public static Visit findLastStartedUnfinishedVisit(Visit[] visitArray, long mouseID, long cageID) {
        if (visitArray == null || visitArray.length == 0 || mouseID == 0L || cageID == 0L) {
            return null;
        }
        Vector<Visit> candidates = new Vector<Visit>();
        int i = 0;
        while (i < visitArray.length) {
            if (visitArray[i].ivEndDate == null) {
                candidates.add(visitArray[i]);
            }
            ++i;
        }
        if (!candidates.isEmpty()) {
            Visit lastStartedVisit = null;
            long lastStartMillis = Long.MIN_VALUE;
            Iterator iter = candidates.iterator();
            while (iter.hasNext()) {
                long vsdm;
                Visit visit = (Visit)iter.next();
                if (visit.ivMouseID != mouseID || visit.ivCageID != cageID || visit.ivStartDate == null || (vsdm = visit.ivStartDate.getTime()) <= lastStartMillis) continue;
                lastStartMillis = vsdm;
                lastStartedVisit = visit;
            }
            return lastStartedVisit;
        }
        return null;
    }

    public static Visit findEndingVisitInMouse(Visit[] arr, long cageID, long millis) {
        if (arr != null) {
            int i = 0;
            while (i < arr.length) {
                if (arr[i].ivCageID == cageID && arr[i].ivEndDate != null && arr[i].ivEndDate.getTime() == millis) {
                    return arr[i];
                }
                ++i;
            }
        }
        return null;
    }

    public static Vector findStartingVisits(Visit[] arr, long millis) {
        Vector<Visit> v = new Vector<Visit>();
        if (arr != null) {
            int i = 0;
            while (i < arr.length) {
                if (arr[i].ivStartDate.getTime() == millis) {
                    v.add(arr[i]);
                }
                ++i;
            }
        }
        return v;
    }

    public static String translateMode(int mode) {
        return StringHelper.getStringForInt(mode, MODI, MODI_BABELS, true, Babel.get("UNDEFINED"));
    }

    public static Date findLatestStartDate(Vector visits) {
        if (visits == null || visits.isEmpty()) {
            return null;
        }
        long max = 0L;
        int i = 0;
        while (i < visits.size()) {
            long l;
            Visit v = (Visit)visits.elementAt(i);
            if (v.ivStartDate != null && (l = v.ivStartDate.getTime()) > max) {
                max = l;
            }
            ++i;
        }
        if (max == 0L) {
            return null;
        }
        return new Date(max);
    }

    public static Visit[] addVisitToArray(Visit[] visitArray, Visit visit) {
        Visit[] res = Visit.enlargeVisitArray(visitArray, 1);
        res[res.length - 1] = visit;
        return res;
    }

    public static Visit[] enlargeVisitArray(Visit[] visitArray, int anzahl) {
        if (visitArray == null) {
            if (anzahl == 0) {
                return null;
            }
            return new Visit[anzahl];
        }
        Visit[] neu = new Visit[visitArray.length + anzahl];
        int i = 0;
        while (i < visitArray.length) {
            neu[i] = new Visit(visitArray[i]);
            ++i;
        }
        return neu;
    }

    public static Vector getOverlapVisits(Vector masterVisits, Vector checkVisits, int toleranzTage) {
        Vector<Visit> erg = new Vector<Visit>();
        Iterator iter = checkVisits.iterator();
        while (iter.hasNext()) {
            Visit visit = (Visit)iter.next();
            if (!Visit.isThereAnyOverlap(visit, masterVisits, toleranzTage)) continue;
            erg.add(visit);
        }
        return erg;
    }

    public static Vector getOverlapVisits(Visit masterVisit, Visit[] checkVisits, int toleranzTage) {
        Vector<Visit> erg = new Vector<Visit>();
        if (checkVisits != null && checkVisits.length != 0) {
            int i = 0;
            while (i < checkVisits.length) {
                if (Visit.areTheyOverlapping(masterVisit, checkVisits[i], toleranzTage)) {
                    erg.add(checkVisits[i]);
                }
                ++i;
            }
        }
        return erg;
    }

    public static boolean isThereAnyOverlap(Visit visit, Vector masterVisits, int toleranzTage) {
        Iterator iterator = masterVisits.iterator();
        while (iterator.hasNext()) {
            if (!Visit.areTheyOverlapping(visit, (Visit)iterator.next(), toleranzTage)) continue;
            return true;
        }
        return false;
    }

    public static boolean areTheyOverlapping(Visit vis1, Visit vis2, int toleranzTage) {
        if (vis1 != null && vis2 != null && vis1.ivMouseID != vis2.ivMouseID && vis1.ivCageID == vis2.ivCageID) {
            long jetzt = System.currentTimeMillis();
            int startTag1 = MyDate.getTage(Visit.getMillis(vis1.ivStartDate, jetzt)) - toleranzTage;
            int startTag2 = MyDate.getTage(Visit.getMillis(vis2.ivStartDate, jetzt)) - toleranzTage;
            int endTag1 = MyDate.getTage(Visit.getMillis(vis1.ivEndDate, jetzt));
            int endTag2 = MyDate.getTage(Visit.getMillis(vis2.ivEndDate, jetzt));
            return startTag2 >= startTag1 && startTag2 <= endTag1 || endTag2 >= startTag1 && endTag2 <= endTag1 || startTag1 >= startTag2 && startTag1 <= endTag2 || endTag1 >= startTag2 && endTag1 <= endTag2;
        }
        return false;
    }

    public static int getEndOfOverlap(Visit vis1, Visit vis2, int toleranzTage, int defVal) {
        if (vis1 != null && vis2 != null && vis1.ivMouseID != vis2.ivMouseID && vis1.ivCageID == vis2.ivCageID) {
            long jetzt = System.currentTimeMillis();
            int startTag1 = MyDate.getTage(Visit.getMillis(vis1.ivStartDate, jetzt)) - toleranzTage;
            int startTag2 = MyDate.getTage(Visit.getMillis(vis2.ivStartDate, jetzt)) - toleranzTage;
            int endTag1 = MyDate.getTage(Visit.getMillis(vis1.ivEndDate, jetzt));
            int endTag2 = MyDate.getTage(Visit.getMillis(vis2.ivEndDate, jetzt));
            if (startTag2 >= startTag1 && startTag2 <= endTag1 || endTag2 >= startTag1 && endTag2 <= endTag1 || startTag1 >= startTag2 && startTag1 <= endTag2 || endTag1 >= startTag2 && endTag1 <= endTag2) {
                return endTag1 < endTag2 ? endTag1 : endTag2;
            }
        }
        return defVal;
    }

    private static long getMillis(Date d, long defVal) {
        return d != null ? d.getTime() : defVal;
    }

    public Visit() {
    }

    public Visit(long cageID, long mouseID, Date startDate, int startMode) {
        this.ivCageID = cageID;
        this.ivMouseID = mouseID;
        this.ivStartDate = startDate;
        this.ivEndDate = null;
        this.ivStartMode = startMode;
        this.ivEndMode = 0;
    }

    public Visit(Visit model) {
        this.ivCageID = model.ivCageID;
        this.ivMouseID = model.ivMouseID;
        this.ivStartDate = model.ivStartDate != null ? new Date(model.ivStartDate.getTime()) : null;
        this.ivEndDate = model.ivEndDate != null ? new Date(model.ivEndDate.getTime()) : null;
        this.ivStartMode = model.ivStartMode;
        this.ivEndMode = model.ivEndMode;
    }

    public Visit(Visit model, long start, long end) {
        this.ivCageID = model.ivCageID;
        this.ivMouseID = model.ivMouseID;
        this.ivStartMode = model.ivStartMode;
        this.ivEndMode = model.ivEndMode;
        this.ivStartDate = new Date(start);
        this.ivEndDate = new Date(end);
    }

    public boolean isUnfinished() {
        return this.ivEndDate == null;
    }

    public Visit createIntersectVisit(LongPunkt timespan, long nullVal) {
        long end;
        if (this.ivStartDate == null) {
            return null;
        }
        if (this.ivStartDate.getTime() > timespan.ivY) {
            return null;
        }
        if (this.ivEndDate != null && this.ivEndDate.getTime() < timespan.ivX) {
            return null;
        }
        long start = this.getStart(nullVal);
        if (start < timespan.ivX) {
            start = timespan.ivX;
        }
        if ((end = this.getEnd(nullVal)) > timespan.ivY) {
            end = timespan.ivY;
        }
        return new Visit(this, start, end);
    }

    public long getStart(long defVal) {
        return Visit.getMillis(this.ivStartDate, defVal);
    }

    public long getEnd(long defVal) {
        return Visit.getMillis(this.ivEndDate, defVal);
    }

    public boolean isEnclosed(int datum, int toleranzTageVorn, int toleranzTageHinten) {
        int start = MyDate.getTage(this.getStart(System.currentTimeMillis())) - toleranzTageVorn;
        int end = MyDate.getTage(this.getEnd(System.currentTimeMillis())) + toleranzTageHinten;
        return datum >= start && datum <= end;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Visit) {
            Visit v = (Visit)obj;
            if (this.ivCageID != v.ivCageID) {
                return false;
            }
            if (this.ivMouseID != v.ivMouseID) {
                return false;
            }
            if (this.ivStartMode != v.ivStartMode) {
                return false;
            }
            if (this.ivEndMode != v.ivEndMode) {
                return false;
            }
            if (!Visit.compareDates(this.ivStartDate, v.ivStartDate)) {
                return false;
            }
            return Visit.compareDates(this.ivEndDate, v.ivEndDate);
        }
        return false;
    }

    private static boolean compareDates(Date d1, Date d2) {
        if (d1 == null && d2 == null) {
            return true;
        }
        if (d1 == null || d2 == null) {
            return false;
        }
        return d1.getTime() / 1000L == d2.getTime() / 1000L;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ivCageID = in.readLong();
        this.ivMouseID = in.readLong();
        this.ivStartDate = (Date)in.readObject();
        this.ivEndDate = (Date)in.readObject();
        this.ivStartMode = in.readInt();
        this.ivEndMode = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.ivCageID);
        out.writeLong(this.ivMouseID);
        out.writeObject(this.ivStartDate);
        out.writeObject(this.ivEndDate);
        out.writeInt(this.ivStartMode);
        out.writeInt(this.ivEndMode);
    }
}

